/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.tree;

import java.io.Serializable;
import java.text.Collator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.tree.DocumentTreeSorter;

public class DefaultDocumentTreeSorter
implements DocumentTreeSorter {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DefaultDocumentTreeSorter.class);
    static final Collator collator = Collator.getInstance();
    protected String sortPropertyPath;

    @Override
    public String getSortPropertyPath() {
        return this.sortPropertyPath;
    }

    @Override
    public void setSortPropertyPath(String sortPropertyPath) {
        this.sortPropertyPath = sortPropertyPath;
    }

    @Override
    public int compare(DocumentModel doc1, DocumentModel doc2) {
        Serializable v2;
        Serializable v1;
        if (this.sortPropertyPath == null) {
            log.error((Object)"Cannot sort: no sort property path set");
            return 0;
        }
        if (doc1 == null && doc2 == null) {
            return 0;
        }
        if (doc1 == null) {
            return -1;
        }
        if (doc2 == null) {
            return 1;
        }
        try {
            v1 = doc1.getPropertyValue(this.sortPropertyPath);
        }
        catch (ClientException e) {
            v1 = null;
        }
        try {
            v2 = doc2.getPropertyValue(this.sortPropertyPath);
        }
        catch (ClientException e) {
            v2 = null;
        }
        boolean useHash = false;
        if (v1 == null && v2 == null) {
            useHash = true;
        } else {
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
        }
        int cmp = v1 instanceof Long && v2 instanceof Long ? ((Long)v1).compareTo((Long)v2) : (v1 instanceof Integer && v2 instanceof Integer ? ((Integer)v1).compareTo((Integer)v2) : (!useHash ? collator.compare(v1.toString(), v2.toString()) : 0));
        if (cmp == 0) {
            useHash = true;
        }
        if (useHash) {
            if (doc1.hashCode() == doc2.hashCode()) {
                return 0;
            }
            if (doc1.hashCode() < doc2.hashCode()) {
                return -1;
            }
            return 1;
        }
        return cmp;
    }

    static {
        collator.setStrength(0);
    }
}

