/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RspCollector;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Scheduler;
import org.jgroups.util.SchedulerListener;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class RequestCorrelator {
    protected Object transport = null;
    protected final Map requests = new ConcurrentReaderHashMap();
    protected RequestHandler request_handler = null;
    protected String name = null;
    protected Scheduler scheduler = null;
    protected Address local_addr = null;
    protected Stack call_stack = null;
    protected boolean deadlock_detection = false;
    private CallStackSetter call_stack_setter = null;
    protected boolean concurrent_processing = false;
    protected boolean started = false;
    protected static final Log log = LogFactory.getLog((Class)RequestCorrelator.class);
    static /* synthetic */ Class class$java$util$LinkedList;

    public RequestCorrelator(String name, Object transport, RequestHandler handler) {
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, Address local_addr) {
        this.name = name;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, boolean concurrent_processing) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.concurrent_processing = concurrent_processing;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, Address local_addr) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, Address local_addr, boolean concurrent_processing) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.concurrent_processing = concurrent_processing;
        this.start();
    }

    public void setDeadlockDetection(boolean flag) {
        if (this.deadlock_detection != flag) {
            this.deadlock_detection = flag;
            if (this.started) {
                if (this.deadlock_detection) {
                    this.startScheduler();
                } else {
                    this.stopScheduler();
                }
            }
        }
    }

    public void setRequestHandler(RequestHandler handler) {
        this.request_handler = handler;
        this.start();
    }

    public void setConcurrentProcessing(boolean concurrent_processing) {
        this.concurrent_processing = concurrent_processing;
    }

    public void sendRequest(long id, Message msg, RspCollector coll) {
        this.sendRequest(id, null, msg, coll);
    }

    public void sendRequest(long id, List dest_mbrs, Message msg, RspCollector coll) {
        block13: {
            if (this.transport == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"transport is not available !");
                }
                return;
            }
            Header hdr = new Header(0, id, coll != null, this.name);
            hdr.dest_mbrs = dest_mbrs;
            if (coll != null) {
                if (this.deadlock_detection) {
                    if (this.local_addr == null) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"local address is null !");
                        }
                        return;
                    }
                    Stack new_call_stack = this.call_stack != null ? (Stack)this.call_stack.clone() : new Stack();
                    new_call_stack.push(this.local_addr);
                    hdr.callStack = new_call_stack;
                }
                this.addEntry(hdr.id, new RequestEntry(coll));
            }
            msg.putHeader(this.name, hdr);
            try {
                if (this.transport instanceof Protocol) {
                    ((Protocol)this.transport).passDown(new Event(1, msg));
                } else if (this.transport instanceof Transport) {
                    ((Transport)this.transport).send(msg);
                } else if (log.isErrorEnabled()) {
                    log.error((Object)("transport object has to be either a Transport or a Protocol, however it is a " + this.transport.getClass()));
                }
            }
            catch (Throwable e) {
                if (!log.isWarnEnabled()) break block13;
                log.warn((Object)e.toString());
            }
        }
    }

    public void done(long id) {
        this.removeEntry(id);
    }

    public void receive(Event evt) {
        switch (evt.getType()) {
            case 9: {
                this.receiveSuspect((Address)evt.getArg());
                break;
            }
            case 6: {
                this.receiveView((View)evt.getArg());
                break;
            }
            case 8: {
                this.setLocalAddress((Address)evt.getArg());
                break;
            }
            case 1: {
                if (this.receiveMessage((Message)evt.getArg())) break;
                return;
            }
        }
        if (this.transport instanceof Protocol) {
            ((Protocol)this.transport).passUp(evt);
        } else if (log.isErrorEnabled()) {
            log.error((Object)"we do not pass up messages via Transport");
        }
    }

    public void start() {
        if (this.deadlock_detection) {
            this.startScheduler();
        }
        this.started = true;
    }

    public void stop() {
        this.stopScheduler();
        this.started = false;
    }

    void startScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler();
            if (this.deadlock_detection && this.call_stack_setter == null) {
                this.call_stack_setter = new CallStackSetter();
                this.scheduler.setListener(this.call_stack_setter);
            }
            if (this.concurrent_processing) {
                this.scheduler.setConcurrentProcessing(this.concurrent_processing);
            }
            this.scheduler.start();
        }
    }

    void stopScheduler() {
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
    }

    public void receiveSuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("suspect=" + mbr));
        }
        Iterator it = this.requests.values().iterator();
        while (it.hasNext()) {
            RequestEntry entry = (RequestEntry)it.next();
            if (entry.coll == null) continue;
            entry.coll.suspect(mbr);
        }
    }

    public void receiveView(View new_view) {
        Iterator it = this.requests.values().iterator();
        while (it.hasNext()) {
            RequestEntry entry = (RequestEntry)it.next();
            if (entry.coll == null) continue;
            entry.coll.viewChange(new_view);
        }
    }

    public boolean receiveMessage(Message msg) {
        org.jgroups.Header tmpHdr = msg.getHeader(this.name);
        if (tmpHdr == null || !(tmpHdr instanceof Header)) {
            return true;
        }
        Header hdr = (Header)tmpHdr;
        if (hdr.corrName == null || !hdr.corrName.equals(this.name)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)new StringBuffer("name of request correlator header (").append(hdr.corrName).append(") is different from ours (").append(this.name).append("). Msg not accepted, passed up"));
            }
            return true;
        }
        List dests = hdr.dest_mbrs;
        if (dests != null && this.local_addr != null && !dests.contains(this.local_addr)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)new StringBuffer("discarded request from ").append(msg.getSrc()).append(" as we are not part of destination list (local_addr=").append(this.local_addr).append(", hdr=").append(hdr).append(')'));
            }
            return false;
        }
        switch (hdr.type) {
            case 0: {
                if (this.request_handler == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"there is no request handler installed to deliver request !");
                    }
                    return false;
                }
                if (this.deadlock_detection) {
                    if (this.scheduler == null) {
                        log.error((Object)"deadlock_detection is true, but scheduler is null: this is not supposed to happen (discarding request)");
                        break;
                    }
                    Request req = new Request(msg);
                    Stack stack = hdr.callStack;
                    if (hdr.rsp_expected && stack != null && this.local_addr != null && stack.contains(this.local_addr)) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("call stack=" + hdr.callStack + " contains " + this.local_addr + ": adding request to priority queue"));
                        }
                        this.scheduler.addPrio(req);
                        break;
                    }
                    this.scheduler.add(req);
                    break;
                }
                this.handleRequest(msg);
                break;
            }
            case 1: {
                msg.removeHeader(this.name);
                RspCollector coll = this.findEntry(hdr.id);
                if (coll == null) break;
                coll.receiveResponse(msg);
                break;
            }
            default: {
                msg.removeHeader(this.name);
                if (!log.isErrorEnabled()) break;
                log.error((Object)"header's type is neither REQ nor RSP !");
            }
        }
        return false;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public void setLocalAddress(Address local_addr) {
        this.local_addr = local_addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(long id, RequestEntry entry) {
        Long id_obj = new Long(id);
        Map map = this.requests;
        synchronized (map) {
            if (!this.requests.containsKey(id_obj)) {
                this.requests.put(id_obj, entry);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("entry " + entry + " for request-id=" + id + " already present !"));
            }
        }
    }

    private void removeEntry(long id) {
        Long id_obj = new Long(id);
        this.requests.remove(id_obj);
    }

    private RspCollector findEntry(long id) {
        Long id_obj = new Long(id);
        RequestEntry entry = (RequestEntry)this.requests.get(id_obj);
        return entry != null ? entry.coll : null;
    }

    private void handleRequest(Message req) {
        block21: {
            Object retval;
            byte[] rsp_buf = null;
            Header hdr = (Header)req.removeHeader(this.name);
            if (log.isTraceEnabled()) {
                log.trace((Object)new StringBuffer("calling (").append(this.request_handler != null ? this.request_handler.getClass().getName() : "null").append(") with request ").append(hdr.id));
            }
            try {
                retval = this.request_handler.handle(req);
            }
            catch (Throwable t) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"error invoking method", t);
                }
                retval = t;
            }
            if (!hdr.rsp_expected) {
                return;
            }
            if (this.transport == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"failure sending response; no transport available");
                }
                return;
            }
            try {
                rsp_buf = Util.objectToByteBuffer(retval);
            }
            catch (Throwable t) {
                try {
                    rsp_buf = Util.objectToByteBuffer(t);
                }
                catch (Throwable tt) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("failed sending rsp: return value (" + retval + ") is not serializable"));
                    }
                    return;
                }
            }
            Message rsp = req.makeReply();
            if (rsp_buf != null) {
                rsp.setBuffer(rsp_buf);
            }
            Header rsp_hdr = new Header(1, hdr.id, false, this.name);
            rsp.putHeader(this.name, rsp_hdr);
            if (log.isTraceEnabled()) {
                log.trace((Object)new StringBuffer("sending rsp for ").append(rsp_hdr.id).append(" to ").append(rsp.getDest()));
            }
            try {
                if (this.transport instanceof Protocol) {
                    ((Protocol)this.transport).passDown(new Event(1, rsp));
                } else if (this.transport instanceof Transport) {
                    ((Transport)this.transport).send(rsp);
                } else if (log.isErrorEnabled()) {
                    log.error((Object)("transport object has to be either a Transport or a Protocol, however it is a " + this.transport.getClass()));
                }
            }
            catch (Throwable e) {
                if (!log.isErrorEnabled()) break block21;
                log.error((Object)"failed sending the response", e);
            }
        }
    }

    private class Request
    implements Runnable {
        public final Message req;

        public Request(Message req) {
            this.req = req;
        }

        public void run() {
            RequestCorrelator.this.handleRequest(this.req);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.req != null) {
                sb.append("req=" + this.req + ", headers=" + this.req.printObjectHeaders());
            }
            return sb.toString();
        }
    }

    private class CallStackSetter
    implements SchedulerListener {
        private CallStackSetter() {
        }

        public void started(Runnable r) {
            this.setCallStack(r);
        }

        public void stopped(Runnable r) {
            this.setCallStack(null);
        }

        public void suspended(Runnable r) {
            this.setCallStack(null);
        }

        public void resumed(Runnable r) {
            this.setCallStack(r);
        }

        void setCallStack(Runnable r) {
            if (r == null) {
                RequestCorrelator.this.call_stack = null;
                return;
            }
            Message req = ((Request)r).req;
            if (req == null) {
                return;
            }
            org.jgroups.Header obj = req.getHeader(RequestCorrelator.this.name);
            if (obj == null || !(obj instanceof Header)) {
                return;
            }
            Header hdr = (Header)obj;
            if (!hdr.rsp_expected) {
                return;
            }
            Stack new_stack = hdr.callStack;
            if (new_stack != null) {
                RequestCorrelator.this.call_stack = (Stack)new_stack.clone();
            }
        }
    }

    public static final class Header
    extends org.jgroups.Header
    implements Streamable {
        public static final byte REQ = 0;
        public static final byte RSP = 1;
        public byte type = 0;
        public long id = 0L;
        public boolean rsp_expected = true;
        public String corrName = null;
        public Stack callStack = null;
        public List dest_mbrs = null;

        public Header() {
        }

        public Header(byte type, long id, boolean rsp_expected, String name) {
            this.type = type;
            this.id = id;
            this.rsp_expected = rsp_expected;
            this.corrName = name;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("[Header: name=" + this.corrName + ", type=");
            ret.append(this.type == 0 ? "REQ" : (this.type == 1 ? "RSP" : "<unknown>"));
            ret.append(", id=" + this.id);
            ret.append(", rsp_expected=" + this.rsp_expected + ']');
            if (this.callStack != null) {
                ret.append(", call stack=" + this.callStack);
            }
            if (this.dest_mbrs != null) {
                ret.append(", dest_mbrs=").append(this.dest_mbrs);
            }
            return ret.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            out.writeBoolean(this.rsp_expected);
            if (this.corrName != null) {
                out.writeBoolean(true);
                out.writeUTF(this.corrName);
            } else {
                out.writeBoolean(false);
            }
            out.writeObject(this.callStack);
            out.writeObject(this.dest_mbrs);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.rsp_expected = in.readBoolean();
            if (in.readBoolean()) {
                this.corrName = in.readUTF();
            }
            this.callStack = (Stack)in.readObject();
            this.dest_mbrs = (List)in.readObject();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            out.writeBoolean(this.rsp_expected);
            if (this.corrName != null) {
                out.writeBoolean(true);
                out.writeUTF(this.corrName);
            } else {
                out.writeBoolean(false);
            }
            if (this.callStack != null) {
                out.writeBoolean(true);
                out.writeShort(this.callStack.size());
                for (int i = 0; i < this.callStack.size(); ++i) {
                    Address mbr = (Address)this.callStack.elementAt(i);
                    Util.writeAddress(mbr, out);
                }
            } else {
                out.writeBoolean(false);
            }
            Util.writeAddresses(this.dest_mbrs, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.rsp_expected = in.readBoolean();
            boolean present = in.readBoolean();
            if (present) {
                this.corrName = in.readUTF();
            }
            if (present = in.readBoolean()) {
                this.callStack = new Stack();
                short len = in.readShort();
                for (short i = 0; i < len; i = (short)(i + 1)) {
                    Address tmp = Util.readAddress(in);
                    this.callStack.add(tmp);
                }
            }
            this.dest_mbrs = (List)Util.readAddresses(in, class$java$util$LinkedList == null ? (class$java$util$LinkedList = RequestCorrelator.class$("java.util.LinkedList")) : class$java$util$LinkedList);
        }

        public long size() {
            long retval = 10L;
            ++retval;
            if (this.corrName != null) {
                retval += (long)(this.corrName.length() + 2);
            }
            ++retval;
            if (this.callStack != null) {
                retval += 2L;
                if (this.callStack.size() > 0) {
                    Address mbr = (Address)this.callStack.firstElement();
                    retval += (long)(this.callStack.size() * Util.size(mbr));
                }
            }
            return retval += Util.size(this.dest_mbrs);
        }
    }

    private static class RequestEntry {
        public RspCollector coll = null;

        public RequestEntry(RspCollector coll) {
            this.coll = coll;
        }
    }
}

