/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;

public class MERGEFAST
extends Protocol {
    Address local_addr = null;
    boolean is_coord = false;
    static final String name = "MERGEFAST";

    public String getName() {
        return name;
    }

    public void down(Event evt) {
        Message msg;
        Address dest;
        if (this.is_coord && evt.getType() == 1 && this.local_addr != null && ((dest = (msg = (Message)evt.getArg()).getDest()) == null || dest.isMulticastAddress())) {
            msg.putHeader(this.getName(), new MergefastHeader(this.local_addr));
        }
        if (evt.getType() == 6) {
            this.handleViewChange((View)evt.getArg());
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Address other_coord;
                if (!this.is_coord) break;
                Message msg = (Message)evt.getArg();
                MergefastHeader hdr = (MergefastHeader)msg.removeHeader(name);
                this.passUp(evt);
                if (hdr != null && this.local_addr != null && !this.local_addr.equals(other_coord = hdr.coord)) {
                    this.sendUpMerge(new Address[]{this.local_addr, other_coord});
                }
                return;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
            }
        }
        this.passUp(evt);
    }

    void handleViewChange(View v) {
        if (this.local_addr == null) {
            return;
        }
        Vector mbrs = v.getMembers();
        this.is_coord = mbrs != null && mbrs.size() > 0 && this.local_addr.equals(mbrs.firstElement());
    }

    void sendUpMerge(Address[] addresses) {
        Vector<Address> v = new Vector<Address>(11);
        for (int i = 0; i < addresses.length; ++i) {
            Address addr = addresses[i];
            v.add(addr);
        }
        this.passUp(new Event(14, v));
    }

    public static class MergefastHeader
    extends Header {
        Address coord = null;

        public MergefastHeader() {
        }

        public MergefastHeader(Address coord) {
            this.coord = coord;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.coord);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.coord = (Address)in.readObject();
        }
    }
}

