/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.WanPipeAddress;
import org.jgroups.util.List;

public class WANPING
extends Discovery {
    int port_range = 5;
    List initial_hosts = null;

    public String getName() {
        return "WANPING";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("port_range");
        if (str != null) {
            this.port_range = Integer.parseInt(str);
            props.remove("port_range");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("initial_hosts: " + this.initial_hosts));
            }
        }
        if (this.initial_hosts == null || this.initial_hosts.size() == 0) {
            this.log.error((Object)"WANPING.setProperties(): hosts to contact for initial membership not specified. Cannot determine coordinator !");
            return false;
        }
        return super.setProperties(props);
    }

    public void sendGetMembersRequest() {
        PingHeader hdr = new PingHeader(1, null);
        Message msg = new Message(null, null, null);
        msg.putHeader(this.getName(), hdr);
        Enumeration en = this.initial_hosts.elements();
        while (en.hasMoreElements()) {
            String h = (String)en.nextElement();
            Message copy = msg.copy();
            copy.setDest(new WanPipeAddress(h));
            this.passDown(new Event(1, copy));
        }
    }

    private List createInitialHosts(String l) {
        List tmp = new List();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                tmp.add(t.trim());
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("WANPING.createInitialHosts(): " + e));
            }
        }
        return tmp;
    }
}

