/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.util.Rsp;

public class RspList {
    final Vector rsps = new Vector();

    public RspList() {
    }

    public RspList(Collection responses) {
        this.rsps.addAll(responses);
    }

    public void reset() {
        this.rsps.removeAllElements();
    }

    public void addRsp(Address sender, Object retval) {
        Rsp rsp = this.find(sender);
        if (rsp != null) {
            rsp.sender = sender;
            rsp.retval = retval;
            rsp.received = true;
            rsp.suspected = false;
            return;
        }
        this.rsps.addElement(new Rsp(sender, retval));
    }

    public void addNotReceived(Address sender) {
        Rsp rsp = this.find(sender);
        if (rsp == null) {
            this.rsps.addElement(new Rsp(sender));
        }
    }

    public void addSuspect(Address sender) {
        Rsp rsp = this.find(sender);
        if (rsp != null) {
            rsp.sender = sender;
            rsp.retval = null;
            rsp.received = false;
            rsp.suspected = true;
            return;
        }
        this.rsps.addElement(new Rsp(sender, true));
    }

    public boolean isReceived(Address sender) {
        Rsp rsp = this.find(sender);
        if (rsp == null) {
            return false;
        }
        return rsp.received;
    }

    public int numSuspectedMembers() {
        int num = 0;
        for (int i = 0; i < this.rsps.size(); ++i) {
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            if (!rsp.wasSuspected()) continue;
            ++num;
        }
        return num;
    }

    public Object getFirst() {
        return this.rsps.size() > 0 ? ((Rsp)this.rsps.elementAt(0)).getValue() : null;
    }

    public Vector getResults() {
        Vector<Object> ret = new Vector<Object>();
        for (int i = 0; i < this.rsps.size(); ++i) {
            Object val;
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            if (!rsp.wasReceived() || (val = rsp.getValue()) == null) continue;
            ret.addElement(val);
        }
        return ret;
    }

    public Vector getSuspectedMembers() {
        Vector<Address> retval = new Vector<Address>();
        for (int i = 0; i < this.rsps.size(); ++i) {
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            if (!rsp.wasSuspected()) continue;
            retval.addElement(rsp.getSender());
        }
        return retval;
    }

    public boolean isSuspected(Address sender) {
        Rsp rsp = this.find(sender);
        if (rsp == null) {
            return false;
        }
        return rsp.suspected;
    }

    public Object get(Address sender) {
        Rsp rsp = this.find(sender);
        if (rsp == null) {
            return null;
        }
        return rsp.retval;
    }

    public int size() {
        return this.rsps.size();
    }

    public Object elementAt(int i) throws ArrayIndexOutOfBoundsException {
        return this.rsps.elementAt(i);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.rsps.size(); ++i) {
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            ret.append("[" + rsp + "]\n");
        }
        return ret.toString();
    }

    boolean contains(Address sender) {
        for (int i = 0; i < this.rsps.size(); ++i) {
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            if (rsp.sender == null || sender == null || !rsp.sender.equals(sender)) continue;
            return true;
        }
        return false;
    }

    Rsp find(Address sender) {
        for (int i = 0; i < this.rsps.size(); ++i) {
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            if (rsp.sender == null || sender == null || !rsp.sender.equals(sender)) continue;
            return rsp;
        }
        return null;
    }
}

