/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.contentview;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.platform.ui.web.cache.LRUCachingMap;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentView;

public class ContentViewCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Integer DEFAULT_CACHE_SIZE = new Integer(5);
    protected final Map<String, String> namedCacheKeys = new HashMap<String, String>();
    protected final Map<String, ContentView> namedContentViews = new HashMap<String, ContentView>();
    protected final Map<String, Map<String, ContentView>> cacheInstances = new HashMap<String, Map<String, ContentView>>();
    protected final Map<String, Set<String>> eventToContentViewName = new HashMap<String, Set<String>>();

    public void add(ContentView cView) {
        if (cView != null) {
            String cacheKey = cView.getCacheKey();
            if (cacheKey == null) {
                return;
            }
            String name = cView.getName();
            Integer cacheSize = cView.getCacheSize();
            if (cacheSize == null) {
                cacheSize = DEFAULT_CACHE_SIZE;
            }
            if (cacheSize <= 0) {
                return;
            }
            Map<String, ContentView> cacheEntry = this.cacheInstances.get(name);
            if (cacheEntry == null) {
                cacheEntry = new LRUCachingMap<String, ContentView>(cacheSize);
            }
            cacheEntry.put(cacheKey, cView);
            this.cacheInstances.put(name, cacheEntry);
            this.namedCacheKeys.put(name, cacheKey);
            this.namedContentViews.put(name, cView);
            List<String> events = cView.getRefreshEventNames();
            if (events != null && !events.isEmpty()) {
                for (String event : events) {
                    if (this.eventToContentViewName.containsKey(event)) {
                        this.eventToContentViewName.get(event).add(name);
                        continue;
                    }
                    HashSet<String> set = new HashSet<String>();
                    set.add(name);
                    this.eventToContentViewName.put(event, set);
                }
            }
        }
    }

    public ContentView get(String name) {
        ContentView cView = this.namedContentViews.get(name);
        if (cView != null) {
            String oldCacheKey = this.namedCacheKeys.get(name);
            String newCacheKey = cView.getCacheKey();
            if (newCacheKey != null && !newCacheKey.equals(oldCacheKey)) {
                Map<String, ContentView> contentViews = this.cacheInstances.get(name);
                if (contentViews.containsKey(newCacheKey)) {
                    cView = contentViews.get(newCacheKey);
                    this.namedCacheKeys.put(name, newCacheKey);
                    this.namedContentViews.put(name, cView);
                } else {
                    return null;
                }
            }
        }
        return cView;
    }

    public void refresh(String contentViewName) {
        Map<String, ContentView> instances;
        ContentView cv = this.namedContentViews.get(contentViewName);
        if (cv != null) {
            cv.refreshPageProvider();
        }
        if ((instances = this.cacheInstances.get(contentViewName)) != null) {
            for (ContentView cView : instances.values()) {
                if (cView == null) continue;
                cView.refreshPageProvider();
            }
        }
    }

    public void refreshOnEvent(String eventName) {
        Set<String> contentViewNames;
        if (eventName != null && (contentViewNames = this.eventToContentViewName.get(eventName)) != null) {
            for (String contentViewName : contentViewNames) {
                this.refresh(contentViewName);
            }
        }
    }

    public void reset(String contentViewName) {
        this.namedContentViews.remove(contentViewName);
        this.namedCacheKeys.remove(contentViewName);
        this.cacheInstances.remove(contentViewName);
    }
}

