/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.contentview;

import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PageProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentView;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentViewLayout;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentViewService;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class ContentViewImpl
implements ContentView {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ContentViewImpl.class);
    protected String name;
    protected PageProvider<?> pageProvider;
    protected String title;
    protected boolean translateTitle;
    protected String iconPath;
    protected String selectionList;
    protected String pagination;
    protected List<String> actionCategories;
    protected ContentViewLayout searchLayout;
    protected List<ContentViewLayout> resultLayouts;
    protected List<String> flags;
    protected ContentViewLayout currentResultLayout;
    protected String cacheKey;
    protected Integer cacheSize;
    protected List<String> refreshEventNames;
    protected boolean useGlobalPageSize;
    protected String[] queryParameters;
    protected DocumentModel searchDocumentModel;
    protected String searchDocumentModelBinding;
    protected String searchDocumentModelType;

    public ContentViewImpl(String name, String title, boolean translateTitle, String iconPath, String selectionList, String pagination, List<String> actionCategories, ContentViewLayout searchLayout, List<ContentViewLayout> resultLayouts, List<String> flags, String cacheKey, Integer cacheSize, List<String> refreshEventNames, boolean useGlobalPageSize, String[] queryParameters, String searchDocumentModelBinding, String searchDocumentModelType) {
        this.name = name;
        this.title = title;
        this.translateTitle = translateTitle;
        this.iconPath = iconPath;
        this.selectionList = selectionList;
        this.pagination = pagination;
        this.actionCategories = actionCategories;
        this.searchLayout = searchLayout;
        this.resultLayouts = resultLayouts;
        this.flags = flags;
        this.cacheKey = cacheKey;
        this.cacheSize = cacheSize;
        this.refreshEventNames = refreshEventNames;
        this.useGlobalPageSize = useGlobalPageSize;
        this.queryParameters = queryParameters;
        this.searchDocumentModelBinding = searchDocumentModelBinding;
        this.searchDocumentModelType = searchDocumentModelType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean getTranslateTitle() {
        return this.translateTitle;
    }

    @Override
    public String getIconPath() {
        return this.iconPath;
    }

    @Override
    public String getSelectionListName() {
        return this.selectionList;
    }

    @Override
    public String getPagination() {
        return this.pagination;
    }

    @Override
    public List<String> getActionsCategories() {
        return this.actionCategories;
    }

    @Override
    public ContentViewLayout getSearchLayout() {
        return this.searchLayout;
    }

    @Override
    public List<ContentViewLayout> getResultLayouts() {
        return this.resultLayouts;
    }

    @Override
    public ContentViewLayout getCurrentResultLayout() {
        if (this.currentResultLayout == null && this.resultLayouts != null && !this.resultLayouts.isEmpty()) {
            this.currentResultLayout = this.resultLayouts.get(0);
        }
        return this.currentResultLayout;
    }

    @Override
    public void setCurrentResultLayout(ContentViewLayout layout) {
        this.currentResultLayout = layout;
    }

    protected boolean getParametersChanged(Object[] oldParams, Object[] newParams) {
        if (oldParams == null && newParams == null) {
            return true;
        }
        if (oldParams != null && newParams != null) {
            if (oldParams.length != newParams.length) {
                return true;
            }
            for (int i = 0; i < oldParams.length; ++i) {
                if (oldParams[i] == null && newParams[i] == null) continue;
                if (oldParams[i] != null && newParams[i] != null) {
                    if (oldParams[i].equals(newParams[i])) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public PageProvider<?> getPageProvider(DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Object ... params) throws ClientException {
        if (params == null) {
            params = this.getQueryParameters();
        }
        if (this.pageProvider == null || this.getParametersChanged(this.pageProvider.getParameters(), params)) {
            try {
                ContentViewService service = (ContentViewService)Framework.getService(ContentViewService.class);
                if (service == null) {
                    throw new ClientException("Could not resolve ContentViewService");
                }
                this.pageProvider = service.getPageProvider(this.getName(), sortInfos, pageSize, currentPage, params);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        } else {
            if (pageSize != null) {
                this.pageProvider.setPageSize(pageSize.longValue());
            }
            if (currentPage != null) {
                this.pageProvider.setCurrentPage(currentPage.longValue());
            }
        }
        if (searchDocument != null) {
            this.pageProvider.setSearchDocumentModel(searchDocument);
        } else {
            DocumentModel searchDoc = this.getSearchDocumentModel();
            if (searchDoc != null && this.pageProvider.getSearchDocumentModel() == null) {
                this.pageProvider.setSearchDocumentModel(searchDoc);
            }
        }
        return this.pageProvider;
    }

    @Override
    public PageProvider<?> getPageProviderWithParams(Object ... params) throws ClientException {
        return this.getPageProvider(null, null, null, null, params);
    }

    @Override
    public PageProvider<?> getPageProvider() throws ClientException {
        return this.getPageProviderWithParams(null);
    }

    @Override
    public PageProvider<?> getCurrentPageProvider() {
        return this.pageProvider;
    }

    @Override
    public void resetPageProvider() {
        this.pageProvider = null;
    }

    @Override
    public void refreshPageProvider() {
        if (this.pageProvider != null) {
            this.pageProvider.refresh();
        }
    }

    @Override
    public String getCacheKey() {
        FacesContext context = FacesContext.getCurrentInstance();
        Object value = ComponentTagUtils.resolveElExpression(context, this.cacheKey);
        if (value != null && !(value instanceof String)) {
            log.error((Object)String.format("Error processing expression '%s', result is not a String: %s", this.cacheKey, value));
        }
        return (String)value;
    }

    @Override
    public Integer getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public Object[] getQueryParameters() {
        if (this.queryParameters == null) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Object[] res = new Object[this.queryParameters.length];
        for (int i = 0; i < this.queryParameters.length; ++i) {
            res[i] = ComponentTagUtils.resolveElExpression(context, this.queryParameters[i]);
        }
        return res;
    }

    @Override
    public List<String> getRefreshEventNames() {
        return this.refreshEventNames;
    }

    @Override
    public boolean getUseGlobalPageSize() {
        return this.useGlobalPageSize;
    }

    @Override
    public DocumentModel getSearchDocumentModel() {
        if (this.searchDocumentModel == null && this.searchDocumentModelBinding != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            Object value = ComponentTagUtils.resolveElExpression(context, this.searchDocumentModelBinding);
            if (value != null && !(value instanceof DocumentModel)) {
                log.error((Object)String.format("Error processing expression '%s', result is not a DocumentModel: %s", this.searchDocumentModelBinding, value));
            } else {
                this.searchDocumentModel = (DocumentModel)value;
            }
        }
        return this.searchDocumentModel;
    }

    @Override
    public void setSearchDocumentModel(DocumentModel searchDocumentModel) {
        this.searchDocumentModel = searchDocumentModel;
        if (this.pageProvider != null) {
            this.pageProvider.setSearchDocumentModel(searchDocumentModel);
        }
    }

    @Override
    public void resetSearchDocumentModel() {
        this.searchDocumentModel = null;
        if (this.pageProvider != null) {
            this.pageProvider.setSearchDocumentModel(null);
        }
    }

    @Override
    public String getSearchDocumentModelType() {
        return this.searchDocumentModelType;
    }

    @Override
    public List<String> getFlags() {
        return this.flags;
    }

    public String toString() {
        return String.format("ContentViewImpl [name=%s, title=%s, translateTitle=%s, iconPath=%s, selectionList=%s, pagination=%s, actionCategories=%s, searchLayout=%s, resultLayouts=%s, currentResultLayout=%s, flags=%s, cacheKey=%s, cacheSize=%s, refreshEventNames=%s, useGlobalPageSize=%s, searchDocumentModel=%s]", this.name, this.title, this.translateTitle, this.iconPath, this.selectionList, this.pagination, this.actionCategories, this.searchLayout, this.resultLayouts, this.currentResultLayout, this.flags, this.cacheKey, this.cacheSize, this.refreshEventNames, this.useGlobalPageSize, this.searchDocumentModel);
    }
}

