/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.contentview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PageProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentView;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentViewDescriptor;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentViewImpl;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentViewLayout;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentViewLayoutImpl;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentViewPageProvider;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentViewService;
import org.nuxeo.ecm.platform.ui.web.contentview.CoreQueryDocumentPageProvider;
import org.nuxeo.ecm.platform.ui.web.contentview.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.ui.web.contentview.GenericPageProviderDescriptor;
import org.nuxeo.ecm.platform.ui.web.contentview.PageProviderDescriptor;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ContentViewServiceImpl
extends DefaultComponent
implements ContentViewService {
    public static final String CONTENT_VIEW_EP = "contentViews";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ContentViewServiceImpl.class);
    protected final Map<String, ContentViewDescriptor> contentViews = new HashMap<String, ContentViewDescriptor>();
    protected final Map<String, Set<String>> contentViewsByFlag = new HashMap<String, Set<String>>();

    @Override
    public ContentView getContentView(String name) throws ClientException {
        Boolean translateTitle;
        ContentViewDescriptor desc = this.contentViews.get(name);
        if (desc == null) {
            return null;
        }
        Boolean useGlobalPageSize = desc.getUseGlobalPageSize();
        if (useGlobalPageSize == null) {
            useGlobalPageSize = Boolean.FALSE;
        }
        if ((translateTitle = desc.getTranslateTitle()) == null) {
            translateTitle = Boolean.FALSE;
        }
        ContentViewImpl contentView = new ContentViewImpl(name, desc.getTitle(), translateTitle, desc.getIconPath(), desc.getSelectionListName(), desc.getPagination(), desc.getActionCategories(), desc.getSearchLayout(), desc.getResultLayouts(), desc.getFlags(), desc.getCacheKey(), desc.getCacheSize(), desc.getRefreshEventNames(), useGlobalPageSize, desc.getQueryParameters(), desc.getSearchDocumentBinding(), desc.getSearchDocumentType());
        return contentView;
    }

    @Override
    public Set<String> getContentViewNames() {
        return Collections.unmodifiableSet(this.contentViews.keySet());
    }

    @Override
    public Set<String> getContentViewNames(String flag) {
        HashSet<String> res = new HashSet<String>();
        Set<String> items = this.contentViewsByFlag.get(flag);
        if (items != null) {
            res.addAll(items);
        }
        return res;
    }

    @Override
    public PageProvider<?> getPageProvider(String name, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Object ... parameters) throws ClientException {
        PageProviderDescriptor pageDesc;
        ContentViewPageProvider<DocumentModel> pageProvider;
        ContentViewDescriptor contentViewDesc = this.contentViews.get(name);
        if (contentViewDesc == null) {
            return null;
        }
        CoreQueryPageProviderDescriptor coreDesc = contentViewDesc.getCoreQueryPageProvider();
        GenericPageProviderDescriptor genDesc = contentViewDesc.getGenericPageProvider();
        if (coreDesc != null && coreDesc.isEnabled() && genDesc != null && genDesc.isEnabled()) {
            log.error((Object)String.format("Only one page provider should be registered on content view '%s': take the core query descriptor by default", name));
        }
        if (coreDesc != null && coreDesc.isEnabled()) {
            pageProvider = new CoreQueryDocumentPageProvider();
            pageDesc = coreDesc;
        } else if (genDesc != null && genDesc.isEnabled()) {
            Class<ContentViewPageProvider<?>> klass = genDesc.getPageProviderClass();
            try {
                pageProvider = klass.newInstance();
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
            pageDesc = genDesc;
        } else {
            throw new ClientException(String.format("No page provider defined on content view '%s'", name));
        }
        pageProvider.setName(name);
        pageProvider.setProperties(this.resolvePageProviderProperties(pageDesc.getProperties()));
        pageProvider.setPageProviderDescriptor(pageDesc);
        pageProvider.setSortable(pageDesc.isSortable());
        pageProvider.setParameters(parameters);
        if (sortInfos == null) {
            pageProvider.setSortInfos(pageDesc.getSortInfos());
        } else {
            pageProvider.setSortInfos(sortInfos);
        }
        if (pageSize == null) {
            pageProvider.setPageSize(pageDesc.getPageSize());
        } else {
            pageProvider.setPageSize(pageSize);
        }
        if (currentPage != null && currentPage != 0L) {
            pageProvider.setCurrentPage(currentPage);
        }
        return pageProvider;
    }

    public Map<String, Serializable> resolvePageProviderProperties(Map<String, String> stringProps) throws ClientException {
        try {
            HashMap<String, Serializable> resolvedProps = new HashMap<String, Serializable>();
            for (Map.Entry<String, String> prop : stringProps.entrySet()) {
                resolvedProps.put(prop.getKey(), this.resolveProperty(prop.getValue()));
            }
            return resolvedProps;
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected Serializable resolveProperty(String elExpression) {
        FacesContext context = FacesContext.getCurrentInstance();
        Object value = ComponentTagUtils.resolveElExpression(context, elExpression);
        if (value != null && !(value instanceof Serializable)) {
            log.error((Object)String.format("Error processing expression '%s', result is not serializable: %s", elExpression, value));
            return null;
        }
        return (Serializable)value;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(ContentViewService.class)) {
            return (T)this;
        }
        return null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONTENT_VIEW_EP.equals(extensionPoint)) {
            ContentViewDescriptor desc = (ContentViewDescriptor)contribution;
            String name = desc.getName();
            if (name == null) {
                log.error((Object)"Cannot register content view without a name");
                return;
            }
            boolean enabled = desc.isEnabled();
            if (this.contentViews.containsKey(name)) {
                log.info((Object)("Overriding content view with name " + name));
                ContentViewDescriptor oldDesc = this.contentViews.get(name);
                this.removeContentViewFlags(oldDesc);
                if (enabled) {
                    desc = this.mergeContentViews(oldDesc, desc);
                } else {
                    this.contentViews.remove(name);
                    log.info((Object)("Disabled content view with name " + name));
                }
            }
            if (enabled) {
                log.info((Object)("Registering content view with name " + name));
                this.contentViews.put(name, desc);
                this.addContentViewFlags(desc);
            }
        }
    }

    protected ContentViewDescriptor mergeContentViews(ContentViewDescriptor oldDesc, ContentViewDescriptor newDesc) {
        Boolean useGlobalPageSize;
        String selectionList;
        List<String> flags;
        List<ContentViewLayout> resultLayouts;
        ContentViewLayoutImpl searchLayout;
        List<String> events;
        String pagination;
        GenericPageProviderDescriptor genDesc;
        CoreQueryPageProviderDescriptor coreDesc;
        Integer cacheSize;
        String cacheKey;
        List<String> actions;
        String iconPath;
        Boolean translateTitle;
        String title = newDesc.getTitle();
        if (title != null) {
            oldDesc.title = title;
        }
        if ((translateTitle = newDesc.getTranslateTitle()) != null) {
            oldDesc.translateTitle = translateTitle;
        }
        if ((iconPath = newDesc.getIconPath()) != null) {
            oldDesc.iconPath = iconPath;
        }
        if ((actions = newDesc.getActionCategories()) != null && !actions.isEmpty()) {
            oldDesc.actionCategories = actions;
        }
        if ((cacheKey = newDesc.getCacheKey()) != null) {
            oldDesc.cacheKey = cacheKey;
        }
        if ((cacheSize = newDesc.getCacheSize()) != null) {
            oldDesc.cacheSize = cacheSize;
        }
        if ((coreDesc = newDesc.getCoreQueryPageProvider()) != null && coreDesc.isEnabled()) {
            oldDesc.coreQueryPageProvider = coreDesc;
        }
        if ((genDesc = newDesc.getGenericPageProvider()) != null && genDesc.isEnabled()) {
            oldDesc.genericPageProvider = genDesc;
        }
        if ((pagination = newDesc.getPagination()) != null) {
            oldDesc.pagination = pagination;
        }
        if ((events = newDesc.getRefreshEventNames()) != null && !events.isEmpty()) {
            oldDesc.eventNames = events;
        }
        if ((searchLayout = newDesc.getSearchLayout()) != null) {
            oldDesc.searchLayout = searchLayout;
        }
        if ((resultLayouts = newDesc.getResultLayouts()) != null) {
            Boolean appendResultLayout = newDesc.appendResultLayouts;
            if (Boolean.TRUE.equals(appendResultLayout)) {
                ArrayList<ContentViewLayout> allLayouts = new ArrayList<ContentViewLayout>();
                if (oldDesc.resultLayouts != null) {
                    allLayouts.addAll(oldDesc.resultLayouts);
                }
                allLayouts.addAll(resultLayouts);
                oldDesc.resultLayouts = allLayouts;
            } else {
                oldDesc.resultLayouts = resultLayouts;
            }
        }
        if ((flags = newDesc.getFlags()) != null && !flags.isEmpty()) {
            oldDesc.flags = flags;
        }
        if ((selectionList = newDesc.getSelectionListName()) != null) {
            oldDesc.selectionList = selectionList;
        }
        if ((useGlobalPageSize = newDesc.getUseGlobalPageSize()) != null) {
            oldDesc.useGlobalPageSize = useGlobalPageSize;
        }
        return oldDesc;
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONTENT_VIEW_EP.equals(extensionPoint)) {
            ContentViewDescriptor desc = (ContentViewDescriptor)contribution;
            String name = desc.getName();
            this.contentViews.remove(name);
            this.removeContentViewFlags(desc);
            log.info((Object)("Unregistering content view with name " + name));
        }
    }

    protected void addContentViewFlags(ContentViewDescriptor desc) {
        String name = desc.getName();
        List<String> flags = desc.getFlags();
        if (flags != null) {
            for (String flag : flags) {
                Set<String> items = this.contentViewsByFlag.get(flag);
                if (items == null) {
                    items = new HashSet<String>();
                }
                items.add(name);
                this.contentViewsByFlag.put(flag, items);
            }
        }
    }

    protected void removeContentViewFlags(ContentViewDescriptor desc) {
        String name = desc.getName();
        List<String> flags = desc.getFlags();
        if (flags != null) {
            for (String flag : flags) {
                Set<String> items = this.contentViewsByFlag.get(flag);
                if (items == null) continue;
                items.remove(name);
                this.contentViewsByFlag.put(flag, items);
            }
        }
    }
}

