/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.contentview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentViewPageProvider;
import org.nuxeo.ecm.platform.ui.web.contentview.PageProviderDescriptor;
import org.nuxeo.ecm.platform.ui.web.contentview.SortInfoDescriptor;
import org.nuxeo.ecm.platform.ui.web.contentview.WhereClauseDescriptor;

@XObject(value="genericPageProvider")
public class GenericPageProviderDescriptor
implements PageProviderDescriptor {
    private static final long serialVersionUID = 1L;
    @XNode(value="@enabled")
    private final boolean enabled = true;
    @XNode(value="@class")
    private Class<ContentViewPageProvider<?>> klass;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    Map<String, String> properties = new HashMap<String, String>();
    @XNodeList(value="parameter", type=String[].class, componentType=String.class)
    String[] queryParameters;
    @XNode(value="pageSize")
    long pageSize = 0L;
    @XNode(value="sortable")
    boolean sortable = true;
    @XNodeList(value="sort", type=ArrayList.class, componentType=SortInfoDescriptor.class)
    List<SortInfoDescriptor> sortInfos;
    protected String pattern;
    @XNode(value="pattern@quoteParameters")
    protected boolean quotePatternParameters = true;
    @XNode(value="whereClause")
    protected WhereClauseDescriptor whereClause;

    public Class<ContentViewPageProvider<?>> getPageProviderClass() {
        return this.klass;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String[] getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    @XNode(value="pattern")
    public void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern.replaceAll("\r?\n\\s*", " ");
        }
    }

    @Override
    public boolean getQuotePatternParameters() {
        return this.quotePatternParameters;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public WhereClauseDescriptor getWhereClause() {
        return this.whereClause;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    @Override
    public List<SortInfo> getSortInfos() {
        ArrayList<SortInfo> res = new ArrayList<SortInfo>();
        if (this.sortInfos != null) {
            for (SortInfoDescriptor sortInfo : this.sortInfos) {
                res.add(sortInfo.getSortInfo());
            }
        }
        return res;
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    public boolean isEnabled() {
        return true;
    }
}

