/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.contentview;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.search.api.client.querymodel.Escaper;
import org.nuxeo.ecm.platform.ui.web.contentview.FieldDescriptor;
import org.nuxeo.ecm.platform.ui.web.contentview.PredicateDescriptor;
import org.nuxeo.ecm.platform.ui.web.contentview.WhereClauseDescriptor;
import org.nuxeo.runtime.api.Framework;

public class NXQLQueryBuilder {
    public static final SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");

    private NXQLQueryBuilder() {
    }

    public static String getSortClause(SortInfo ... sortInfos) {
        StringBuilder queryBuilder = new StringBuilder();
        if (sortInfos != null) {
            int index = 0;
            for (SortInfo sortInfo : sortInfos) {
                String sortColumn = sortInfo.getSortColumn();
                boolean sortAscending = sortInfo.getSortAscending();
                if (index == 0) {
                    queryBuilder.append("ORDER BY ").append(sortColumn).append(' ').append(sortAscending ? "" : "DESC");
                } else {
                    queryBuilder.append(", ").append(sortColumn).append(' ').append(sortAscending ? "" : "DESC");
                }
                ++index;
            }
        }
        return queryBuilder.toString();
    }

    public static String getQuery(DocumentModel model, WhereClauseDescriptor whereClause, Object[] params, SortInfo ... sortInfos) throws ClientException {
        String sortClause;
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT * FROM Document");
        if (whereClause != null) {
            queryBuilder.append(NXQLQueryBuilder.getQueryElement(model, whereClause, params));
        }
        if ((sortClause = NXQLQueryBuilder.getSortClause(sortInfos)) != null && sortClause.length() > 0) {
            queryBuilder.append(" ");
            queryBuilder.append(sortClause);
        }
        return queryBuilder.toString().trim();
    }

    public static String getQueryElement(DocumentModel model, WhereClauseDescriptor whereClause, Object[] params) throws ClientException {
        String fixedPart;
        ArrayList<String> elements = new ArrayList<String>();
        PredicateDescriptor[] predicates = whereClause.getPredicates();
        if (predicates != null) {
            try {
                Escaper escaper = whereClause.getEscaperClass().newInstance();
                for (PredicateDescriptor predicate : predicates) {
                    String predicateString = NXQLQueryBuilder.getQueryElement(model, predicate, escaper);
                    if (predicateString == null || (predicateString = predicateString.trim()).equals("")) continue;
                    elements.add(predicateString);
                }
            }
            catch (IllegalAccessException e) {
                throw new ClientException((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ClientException((Throwable)e);
            }
        }
        if ((fixedPart = whereClause.getFixedPart()) != null && !fixedPart.equals("")) {
            if (elements.isEmpty()) {
                elements.add(NXQLQueryBuilder.getQuery(fixedPart, params, whereClause.getQuoteFixedPartParameters(), new SortInfo[0]));
            } else {
                elements.add('(' + NXQLQueryBuilder.getQuery(fixedPart, params, whereClause.getQuoteFixedPartParameters(), new SortInfo[0]) + ')');
            }
        }
        if (elements.isEmpty()) {
            return "";
        }
        String clauseValues = StringUtils.join(elements, (String)" AND ").trim();
        while (elements.size() == 1 && clauseValues.startsWith("(") && clauseValues.endsWith(")")) {
            clauseValues = clauseValues.substring(1, clauseValues.length() - 1).trim();
        }
        if (clauseValues.length() == 0) {
            return "";
        }
        return " WHERE " + clauseValues;
    }

    public static String getQuery(String pattern, Object[] params, boolean quoteParameters, SortInfo ... sortInfos) throws ClientException {
        StringBuilder queryBuilder;
        if (params == null) {
            queryBuilder = new StringBuilder(pattern + ' ');
        } else {
            String[] queryStrList = (pattern + ' ').split("\\?");
            queryBuilder = new StringBuilder(queryStrList[0]);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] instanceof String[]) {
                    NXQLQueryBuilder.appendStringList(queryBuilder, Arrays.asList((String[])params[i]), quoteParameters);
                } else if (params[i] instanceof List) {
                    NXQLQueryBuilder.appendStringList(queryBuilder, (List)params[i], quoteParameters);
                } else if (params[i] instanceof Boolean) {
                    boolean b = (Boolean)params[i];
                    queryBuilder.append(b ? 1 : 0);
                } else if (params[i] instanceof Number) {
                    queryBuilder.append(params[i]);
                } else if (params[i] instanceof Literal) {
                    if (quoteParameters) {
                        queryBuilder.append(params[i].toString());
                    } else {
                        queryBuilder.append(((Literal)params[i]).asString());
                    }
                } else if (params[i] == null) {
                    queryBuilder.append("''");
                } else {
                    String queryParam = params[i].toString();
                    queryBuilder.append(NXQLQueryBuilder.prepareStringLiteral(queryParam, quoteParameters));
                }
                queryBuilder.append(queryStrList[i + 1]);
            }
        }
        queryBuilder.append(NXQLQueryBuilder.getSortClause(sortInfos));
        return queryBuilder.toString().trim();
    }

    public static void appendStringList(StringBuilder queryBuilder, List<?> listParam, boolean quoteParameters) {
        queryBuilder.append('(');
        ArrayList<String> result = new ArrayList<String>(listParam.size());
        for (Object param : listParam) {
            result.add(NXQLQueryBuilder.prepareStringLiteral(param.toString(), quoteParameters));
        }
        queryBuilder.append(StringUtils.join(result, (String)", "));
        queryBuilder.append(')');
    }

    public static String prepareStringLiteral(String s, boolean quoteParameter) {
        String res = s.replaceAll("'", "\\\\'");
        if (quoteParameter) {
            res = "'" + res + "'";
        }
        return res;
    }

    public static String getQueryElement(DocumentModel model, PredicateDescriptor predicateDescriptor, Escaper escaper) throws ClientException {
        String type = predicateDescriptor.getType();
        if ("atomic".equals(type)) {
            return NXQLQueryBuilder.atomicQueryElement(model, predicateDescriptor, escaper);
        }
        if ("subClause".equals(type)) {
            return NXQLQueryBuilder.subClauseQueryElement(model, predicateDescriptor);
        }
        throw new ClientException("Unknown predicate type: " + type);
    }

    protected static String subClauseQueryElement(DocumentModel model, PredicateDescriptor predicateDescriptor) throws ClientException {
        FieldDescriptor[] values = predicateDescriptor.getValues();
        if (values == null || values.length != 1) {
            throw new ClientException("subClause predicate needs exactly one field");
        }
        FieldDescriptor fieldDescriptor = values[0];
        if (!NXQLQueryBuilder.getFieldType(model, fieldDescriptor).equals("string")) {
            if (fieldDescriptor.getXpath() != null) {
                throw new ClientException(String.format("type of field %s is not string", fieldDescriptor.getXpath()));
            }
            throw new ClientException(String.format("type of field %s.%s is not string", fieldDescriptor.getSchema(), fieldDescriptor.getName()));
        }
        return "(" + NXQLQueryBuilder.getRawValue(model, fieldDescriptor) + ")";
    }

    protected static String atomicQueryElement(DocumentModel model, PredicateDescriptor predicateDescriptor, Escaper escaper) throws ClientException {
        String value;
        FieldDescriptor operatorFieldDescriptor;
        String operator = null;
        String operatorField = predicateDescriptor.getOperatorField();
        String operatorSchema = predicateDescriptor.getOperatorSchema();
        String parameter = predicateDescriptor.getParameter();
        FieldDescriptor[] values = predicateDescriptor.getValues();
        if (operatorField != null && operatorSchema != null && (operator = NXQLQueryBuilder.getPlainStringValue(model, operatorFieldDescriptor = new FieldDescriptor(operatorSchema, operatorField))) != null) {
            operator = operator.toUpperCase();
        }
        if (operator == null || "".equals(operator)) {
            operator = predicateDescriptor.getOperator();
        }
        if (operator.equals("=") || operator.equals("!=") || operator.equals("<") || operator.equals(">") || operator.equals("<=") || operator.equals(">=") || operator.equals("<>") || operator.equals("LIKE") || operator.equals("ILIKE")) {
            value = NXQLQueryBuilder.getStringValue(model, values[0]);
            if (value == null) {
                return "";
            }
            if (operator.equals("LIKE") || operator.equals("ILIKE")) {
                value = escaper.escape(value);
            }
            return NXQLQueryBuilder.serializeUnary(parameter, operator, value);
        }
        if (operator.equals("BETWEEN")) {
            String min = NXQLQueryBuilder.getStringValue(model, values[0]);
            String max = NXQLQueryBuilder.getStringValue(model, values[1]);
            if (min != null && max != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(parameter);
                builder.append(' ');
                builder.append(operator);
                builder.append(' ');
                builder.append(min);
                builder.append(" AND ");
                builder.append(max);
                return builder.toString();
            }
            if (max != null) {
                return NXQLQueryBuilder.serializeUnary(parameter, "<=", max);
            }
            if (min != null) {
                return NXQLQueryBuilder.serializeUnary(parameter, ">=", min);
            }
            return "";
        }
        if (operator.equals("IN")) {
            List<String> options = NXQLQueryBuilder.getListValue(model, values[0]);
            if (options == null || options.isEmpty()) {
                return "";
            }
            if (options.size() == 1) {
                return NXQLQueryBuilder.serializeUnary(parameter, "=", options.get(0));
            }
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            for (int i = 0; i < options.size() - 1; ++i) {
                builder.append(NXQLQueryBuilder.serializeUnary(parameter, "=", options.get(i)));
                builder.append(" OR ");
            }
            builder.append(NXQLQueryBuilder.serializeUnary(parameter, "=", options.get(options.size() - 1)));
            builder.append(')');
            return builder.toString();
        }
        if (operator.equals("STARTSWITH")) {
            String fieldType = NXQLQueryBuilder.getFieldType(model, values[0]);
            if (fieldType.equals("string")) {
                String value2 = NXQLQueryBuilder.getStringValue(model, values[0]);
                if (value2 == null) {
                    return "";
                }
                return NXQLQueryBuilder.serializeUnary(parameter, operator, value2);
            }
            List<String> options = NXQLQueryBuilder.getListValue(model, values[0]);
            if (options == null || options.isEmpty()) {
                return "";
            }
            if (options.size() == 1) {
                return NXQLQueryBuilder.serializeUnary(parameter, operator, options.get(0));
            }
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            for (int i = 0; i < options.size() - 1; ++i) {
                builder.append(NXQLQueryBuilder.serializeUnary(parameter, operator, options.get(i)));
                builder.append(" OR ");
            }
            builder.append(NXQLQueryBuilder.serializeUnary(parameter, operator, options.get(options.size() - 1)));
            builder.append(')');
            return builder.toString();
        }
        if (operator.equals("EMPTY") || operator.equals("ISEMPTY")) {
            return parameter + " = ''";
        }
        if (operator.equals("FULLTEXT ALL") || operator.equals("FULLTEXT")) {
            value = NXQLQueryBuilder.getPlainStringValue(model, values[0]);
            if (value == null) {
                return "";
            }
            String lhs = parameter.startsWith("ecm:fulltext") ? parameter : "ecm:fulltext." + parameter;
            return lhs + ' ' + NXQLQueryBuilder.serializeFullText(escaper.escape(value));
        }
        throw new ClientException("Unsupported operator: " + operator);
    }

    protected static String serializeFullText(String value) {
        String res = "";
        String[] tokens = value.split(" ");
        for (int i = 0; i < tokens.length; ++i) {
            if (i != 0) {
                res = res + " ";
            }
            res = res + "+" + tokens[i];
        }
        return "= " + NXQLQueryBuilder.prepareStringLiteral(res, true);
    }

    protected static String serializeUnary(String parameter, String operator, String rvalue) {
        StringBuilder builder = new StringBuilder();
        builder.append(parameter);
        builder.append(' ');
        builder.append(operator);
        builder.append(' ');
        builder.append(rvalue);
        return builder.toString();
    }

    public static String getPlainStringValue(DocumentModel model, FieldDescriptor fieldDescriptor) {
        Object rawValue = NXQLQueryBuilder.getRawValue(model, fieldDescriptor);
        if (rawValue == null) {
            return null;
        }
        String value = (String)rawValue;
        if (value.equals("")) {
            return null;
        }
        return value;
    }

    public static Integer getIntValue(DocumentModel model, FieldDescriptor fieldDescriptor) {
        Object rawValue = NXQLQueryBuilder.getRawValue(model, fieldDescriptor);
        if (rawValue == null || "".equals(rawValue)) {
            return null;
        }
        if (rawValue instanceof Integer) {
            return (Integer)rawValue;
        }
        if (rawValue instanceof String) {
            return Integer.valueOf((String)rawValue);
        }
        return Integer.valueOf(rawValue.toString());
    }

    public static String getFieldType(DocumentModel model, FieldDescriptor fieldDescriptor) throws ClientException {
        String xpath = fieldDescriptor.getXpath();
        String schema = fieldDescriptor.getSchema();
        String name = fieldDescriptor.getName();
        try {
            SchemaManager typeManager = (SchemaManager)Framework.getService(SchemaManager.class);
            Field field = null;
            if (xpath != null) {
                if (model != null) {
                    field = model.getProperty(xpath).getField();
                }
            } else {
                Schema schemaObj = typeManager.getSchema(schema);
                if (schemaObj == null) {
                    throw new ClientException("failed to obtain schema: " + schema);
                }
                field = schemaObj.getField(name);
            }
            if (field == null) {
                throw new ClientException("failed to obtain field: " + schema + ":" + name);
            }
            return field.getType().getName();
        }
        catch (Exception e) {
            throw new ClientException("failed to get field type for " + (xpath != null ? xpath : schema + ":" + name), (Throwable)e);
        }
    }

    public static Object getRawValue(DocumentModel model, FieldDescriptor fieldDescriptor) {
        String xpath = fieldDescriptor.getXpath();
        String schema = fieldDescriptor.getSchema();
        String name = fieldDescriptor.getName();
        try {
            if (xpath != null) {
                return model.getPropertyValue(xpath);
            }
            return model.getProperty(schema, name);
        }
        catch (ClientException e) {
            return null;
        }
    }

    public static String getStringValue(DocumentModel model, FieldDescriptor fieldDescriptor) throws ClientException {
        String value;
        Object rawValue = NXQLQueryBuilder.getRawValue(model, fieldDescriptor);
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof GregorianCalendar) {
            GregorianCalendar gc = (GregorianCalendar)rawValue;
            value = "DATE '" + sf.format(gc.getTime()) + "'";
        } else if (rawValue instanceof Date) {
            Date date = (Date)rawValue;
            value = "DATE '" + sf.format(date) + "'";
        } else if (rawValue instanceof Integer || rawValue instanceof Long || rawValue instanceof Double) {
            value = rawValue.toString();
        } else if (rawValue instanceof Boolean) {
            value = (Boolean)rawValue != false ? "1" : "0";
        } else {
            String value2 = rawValue.toString().trim();
            if (value2.equals("")) {
                return null;
            }
            String fieldType = NXQLQueryBuilder.getFieldType(model, fieldDescriptor);
            if ("long".equals(fieldType) || "integer".equals(fieldType) || "double".equals(fieldType)) {
                return value2;
            }
            return NXQLQueryBuilder.prepareStringLiteral(value2, true);
        }
        return value;
    }

    public static List<String> getListValue(DocumentModel model, FieldDescriptor fieldDescriptor) {
        Object[] rawValue = NXQLQueryBuilder.getRawValue(model, fieldDescriptor);
        if (rawValue == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        if (rawValue instanceof ArrayList) {
            rawValue = ((ArrayList)rawValue).toArray();
        }
        for (Object element : (Object[])rawValue) {
            String value;
            if (element == null || (value = element.toString().trim()).equals("")) continue;
            values.add("'" + value + "'");
        }
        return values;
    }

    public static Boolean getBooleanValue(DocumentModel model, FieldDescriptor fieldDescriptor) {
        Object rawValue = NXQLQueryBuilder.getRawValue(model, fieldDescriptor);
        if (rawValue == null) {
            return null;
        }
        return (Boolean)rawValue;
    }
}

