/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.Serializable;
import java.util.Comparator;
import javax.faces.model.SelectItem;

public class SelectItemComparator
implements Comparator<SelectItem>,
Serializable {
    private static final long serialVersionUID = -2823867424119790285L;
    private final String ordering;
    private final boolean caseSensitive;

    public SelectItemComparator(String ordering, boolean caseSensitive) {
        this.ordering = ordering;
        this.caseSensitive = caseSensitive;
    }

    @Override
    protected int compare(String item1, String item2) {
        try {
            Integer int1 = Integer.valueOf(item1);
            Integer int2 = Integer.valueOf(item2);
            return int1.compareTo(int2);
        }
        catch (NumberFormatException numberFormatException) {
            return item1.compareTo(item2);
        }
    }

    @Override
    public int compare(SelectItem item1, SelectItem item2) {
        if (this.ordering.equals("label")) {
            String label1 = item1.getLabel();
            String label2 = item2.getLabel();
            if (this.caseSensitive) {
                return this.compare(label1, label2);
            }
            return this.compare(label1.toLowerCase(), label2.toLowerCase());
        }
        if (this.ordering.equals("id")) {
            String value1 = String.valueOf(item1.getValue());
            String value2 = String.valueOf(item2.getValue());
            if (this.caseSensitive) {
                return this.compare(value1, value2);
            }
            return this.compare(value1.toLowerCase(), value2.toLowerCase());
        }
        throw new RuntimeException("invalid sort criteria");
    }
}

