/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.invalidations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.core.BijectionInterceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.invalidations.DocumentContextInvalidation;

@Interceptor(stateless=true, within={BijectionInterceptor.class})
public class DocumentContextInvalidatorInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentContextInvalidatorInterceptor.class);

    public Object aroundInvoke(InvocationContext invocationContext) throws Exception {
        this.beforeInvocation(invocationContext);
        return invocationContext.proceed();
    }

    private void beforeInvocation(InvocationContext invocationContext) {
        Object target = invocationContext.getTarget();
        for (Method meth : target.getClass().getMethods()) {
            if (!meth.isAnnotationPresent(DocumentContextInvalidation.class)) continue;
            try {
                this.doInvalidationCall(target, meth);
            }
            catch (Exception e) {
                log.error((Object)"Error during Invalidation method call", (Throwable)e);
            }
        }
    }

    private void doInvalidationCall(Object target, Method meth) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (meth.getParameterTypes().length == 0) {
            meth.invoke(target, new Object[0]);
        } else {
            DocumentModel currentDoc = this.getCurrentDocumentModel();
            if (currentDoc != null) {
                meth.invoke(target, currentDoc);
            } else {
                log.error((Object)"Unable to get CurrentDocument");
            }
        }
    }

    private DocumentModel getCurrentDocumentModel() {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (ScopeType)ScopeType.CONVERSATION);
        return navigationContext.getCurrentDocument();
    }
}

