/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoAuthenticationFilter;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.ui.web.rest.descriptors.URLPatternDescriptor;
import org.nuxeo.ecm.platform.ui.web.rest.descriptors.ValueBindingDescriptor;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;

public class URLPolicyServiceImpl
implements URLPolicyService {
    public static final String NAME = URLPolicyServiceImpl.class.getName();
    private static final Log log = LogFactory.getLog(URLPolicyServiceImpl.class);
    protected final Map<String, URLPatternDescriptor> descriptors = new HashMap<String, URLPatternDescriptor>();

    protected List<URLPatternDescriptor> getURLPatternDescriptors() {
        ArrayList<URLPatternDescriptor> lst = new ArrayList<URLPatternDescriptor>();
        for (URLPatternDescriptor desc : this.descriptors.values()) {
            if (!desc.getEnabled()) continue;
            if (desc.getDefaultURLPolicy()) {
                lst.add(0, desc);
                continue;
            }
            lst.add(desc);
        }
        return lst;
    }

    protected URLPatternDescriptor getDefaultPatternDescriptor() {
        for (URLPatternDescriptor desc : this.descriptors.values()) {
            if (!desc.getEnabled() || !desc.getDefaultURLPolicy()) continue;
            return desc;
        }
        return null;
    }

    @Override
    public String getDefaultPatternName() {
        URLPatternDescriptor desc = this.getDefaultPatternDescriptor();
        if (desc != null) {
            return desc.getName();
        }
        return null;
    }

    protected static DocumentViewCodecManager getDocumentViewCodecService() {
        try {
            return (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve the document view service", (Throwable)e);
            return null;
        }
    }

    protected URLPatternDescriptor getURLPatternDescriptor(String patternName) {
        URLPatternDescriptor desc = this.descriptors.get(patternName);
        if (desc == null) {
            throw new IllegalArgumentException("Unknow pattern " + patternName);
        }
        return desc;
    }

    @Override
    public boolean isCandidateForDecoding(HttpServletRequest httpRequest) {
        String method = httpRequest.getMethod();
        if (!method.equals("GET") && !method.equals("HEAD")) {
            return false;
        }
        URLPatternDescriptor desc = this.getURLPatternDescriptor(httpRequest);
        if (desc != null) {
            return desc.getNeedFilterPreprocessing();
        }
        URLPatternDescriptor defaultPattern = this.getDefaultPatternDescriptor();
        if (defaultPattern != null) {
            return defaultPattern.getNeedFilterPreprocessing();
        }
        return false;
    }

    @Override
    public boolean isCandidateForEncoding(HttpServletRequest httpRequest) {
        Boolean forceEncoding = false;
        Object forceEncodingValue = httpRequest.getAttribute("nuxeo.force.url.encoding");
        if (forceEncodingValue instanceof Boolean) {
            forceEncoding = (Boolean)forceEncodingValue;
        }
        if (!forceEncoding.booleanValue() && !httpRequest.getMethod().equals("POST")) {
            return false;
        }
        Object skipRedirect = httpRequest.getAttribute("nuxeo.disable.redirect.wrapper");
        if (skipRedirect instanceof Boolean && ((Boolean)skipRedirect).booleanValue()) {
            return false;
        }
        URLPatternDescriptor desc = this.getURLPatternDescriptor(httpRequest);
        if (desc != null) {
            return desc.getNeedRedirectFilter();
        }
        URLPatternDescriptor defaultPattern = this.getDefaultPatternDescriptor();
        if (defaultPattern != null) {
            return defaultPattern.getNeedRedirectFilter();
        }
        return false;
    }

    @Override
    public void setDocumentViewInRequest(HttpServletRequest request, DocumentView docView) {
        request.setAttribute("requestedUrl", (Object)NuxeoAuthenticationFilter.getRequestedUrl((HttpServletRequest)request));
        request.setAttribute("DocumentView", (Object)docView);
    }

    protected URLPatternDescriptor getURLPatternDescriptor(HttpServletRequest request) {
        URLPatternDescriptor res = null;
        for (URLPatternDescriptor desc : this.getURLPatternDescriptors()) {
            DocumentView docView = this.getDocumentViewFromRequest(desc.getName(), request);
            if (docView == null) continue;
            res = desc;
            break;
        }
        return res;
    }

    @Override
    public DocumentView getDocumentViewFromRequest(HttpServletRequest request) {
        URLPatternDescriptor desc;
        DocumentView docView = null;
        Iterator<URLPatternDescriptor> i$ = this.getURLPatternDescriptors().iterator();
        while (i$.hasNext() && (docView = this.getDocumentViewFromRequest((desc = i$.next()).getName(), request)) == null) {
        }
        return docView;
    }

    @Override
    public DocumentView getDocumentViewFromRequest(String patternName, HttpServletRequest request) {
        DocumentView requestDocView;
        Object value = request.getAttribute("DocumentView");
        if (value instanceof DocumentView && patternName.equals((requestDocView = (DocumentView)value).getPatternName())) {
            return requestDocView;
        }
        String url = new String(request.getRequestURL());
        URLPatternDescriptor desc = this.getURLPatternDescriptor(patternName);
        String codecName = desc.getDocumentViewCodecName();
        DocumentViewCodecManager docViewService = URLPolicyServiceImpl.getDocumentViewCodecService();
        DocumentView docView = docViewService.getDocumentViewFromUrl(codecName, url, desc.getNeedBaseURL(), BaseURL.getLocalBaseURL((ServletRequest)request));
        if (docView != null) {
            docView.setPatternName(patternName);
            String queryString = request.getQueryString();
            Map requestParameters = URIUtils.getRequestParameters((String)queryString);
            if (requestParameters != null) {
                ValueBindingDescriptor[] bindings;
                for (ValueBindingDescriptor binding : bindings = desc.getValueBindings()) {
                    String paramName = binding.getName();
                    Object paramValue = requestParameters.get(paramName);
                    if (paramValue != null && !(paramValue instanceof String)) continue;
                    docView.addParameter(paramName, (String)paramValue);
                }
            }
        }
        return docView;
    }

    protected URLPatternDescriptor getURLPatternDescriptor(DocumentView docView) {
        URLPatternDescriptor res = null;
        if (docView != null) {
            String patternName = docView.getPatternName();
            try {
                res = this.getURLPatternDescriptor(patternName);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return res;
    }

    @Override
    public String getUrlFromDocumentView(DocumentView docView, String baseUrl) {
        URLPatternDescriptor desc;
        String url = null;
        Iterator<URLPatternDescriptor> i$ = this.getURLPatternDescriptors().iterator();
        while (i$.hasNext() && (url = this.getUrlFromDocumentView((desc = i$.next()).getName(), docView, baseUrl)) == null) {
        }
        return url;
    }

    @Override
    public String getUrlFromDocumentView(String patternName, DocumentView docView, String baseUrl) {
        DocumentViewCodecManager docViewService = URLPolicyServiceImpl.getDocumentViewCodecService();
        URLPatternDescriptor desc = this.getURLPatternDescriptor(patternName);
        String codecName = desc.getDocumentViewCodecName();
        return docViewService.getUrlFromDocumentView(codecName, docView, desc.getNeedBaseURL(), baseUrl);
    }

    @Override
    public void applyRequestParameters(FacesContext facesContext) {
        ValueBindingDescriptor[] bindings;
        String documentViewBinding;
        ExpressionFactory ef = facesContext.getApplication().getExpressionFactory();
        ELContext context = facesContext.getELContext();
        HttpServletRequest httpRequest = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        URLPatternDescriptor pattern = this.getURLPatternDescriptor(httpRequest);
        if (pattern == null) {
            return;
        }
        DocumentView docView = this.getDocumentViewFromRequest(pattern.getName(), httpRequest);
        if (docView != null && (documentViewBinding = pattern.getDocumentViewBinding()) != null && !"".equals(documentViewBinding)) {
            ValueExpression ve = ef.createValueExpression(context, pattern.getDocumentViewBinding(), Object.class);
            ve.setValue(context, (Object)docView);
        }
        if ((bindings = pattern.getValueBindings()) != null) {
            for (ValueBindingDescriptor binding : bindings) {
                String expr;
                String paramName = binding.getName();
                Object value = httpRequest.getAttribute(paramName);
                if (value == null && docView != null) {
                    value = docView.getParameter(paramName);
                }
                if (!ComponentTagUtils.isValueReference(expr = binding.getExpression())) continue;
                ValueExpression ve = ef.createValueExpression(context, expr, Object.class);
                try {
                    ve.setValue(context, value);
                }
                catch (Exception e) {
                    log.error((Object)String.format("Could not apply request parameter %s to expression %s", value, expr));
                }
            }
        }
    }

    @Override
    public void appendParametersToRequest(FacesContext facesContext) {
        this.appendParametersToRequest(facesContext, null);
    }

    public void appendParametersToRequest(FacesContext facesContext, String pattern) {
        DocumentView docView = null;
        ExpressionFactory ef = facesContext.getApplication().getExpressionFactory();
        ELContext context = facesContext.getELContext();
        HttpServletRequest httpRequest = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        URLPatternDescriptor patternDesc = pattern != null && !"".equals(pattern) ? this.getURLPatternDescriptor(pattern) : this.getDefaultPatternDescriptor();
        if (patternDesc != null) {
            ValueExpression ve;
            Object docViewValue = null;
            String documentViewBinding = patternDesc.getDocumentViewBinding();
            if (documentViewBinding != null && !"".equals(documentViewBinding) && (docViewValue = (ve = ef.createValueExpression(context, documentViewBinding, Object.class)).getValue(context)) == null && (documentViewBinding = patternDesc.getNewDocumentViewBinding()) != null && !"".equals(documentViewBinding)) {
                ve = ef.createValueExpression(context, documentViewBinding, Object.class);
                docViewValue = ve.getValue(context);
            }
            if (docViewValue instanceof DocumentView) {
                docView = (DocumentView)docViewValue;
                docView.setPatternName(patternDesc.getName());
                ValueBindingDescriptor[] bindings = patternDesc.getValueBindings();
                if (bindings != null) {
                    for (ValueBindingDescriptor binding : bindings) {
                        String paramName = binding.getName();
                        String expr = binding.getExpression();
                        try {
                            Object value;
                            if (ComponentTagUtils.isValueReference(expr)) {
                                ValueExpression ve2 = ef.createValueExpression(context, expr, Object.class);
                                value = ve2.getValue(context);
                            } else {
                                value = expr;
                            }
                            if (docView != null) {
                                docView.addParameter(paramName, (String)value);
                                continue;
                            }
                            httpRequest.setAttribute(paramName, value);
                        }
                        catch (Exception e) {
                            log.error((Object)String.format("Could not get parameter %s from expression %s", paramName, expr));
                        }
                    }
                }
            }
        }
        this.setDocumentViewInRequest(httpRequest, docView);
    }

    @Override
    public String navigate(FacesContext facesContext) {
        HttpServletRequest httpRequest = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        URLPatternDescriptor pattern = this.getURLPatternDescriptor(httpRequest);
        if (pattern == null) {
            return null;
        }
        DocumentView docView = this.getDocumentViewFromRequest(pattern.getName(), httpRequest);
        ExpressionFactory ef = facesContext.getApplication().getExpressionFactory();
        ELContext context = facesContext.getELContext();
        String actionBinding = pattern.getActionBinding();
        if (actionBinding != null && !"".equals(actionBinding)) {
            MethodExpression action = ef.createMethodExpression(context, actionBinding, String.class, new Class[]{DocumentView.class});
            return (String)action.invoke(context, new Object[]{docView});
        }
        return null;
    }

    @Override
    public void addPatternDescriptor(URLPatternDescriptor pattern) {
        String name = pattern.getName();
        if (this.descriptors.containsKey(name)) {
            this.descriptors.remove(name);
        }
        this.descriptors.put(pattern.getName(), pattern);
        log.debug((Object)("Added URLPatternDescriptor: " + name));
    }

    @Override
    public void removePatternDescriptor(URLPatternDescriptor pattern) {
        String name = pattern.getName();
        this.descriptors.remove(name);
        log.debug((Object)("Removed URLPatternDescriptor: " + name));
    }

    @Override
    public void clear() {
        this.descriptors.clear();
    }
}

