/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.RFC2231;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.Blob;

public final class ComponentUtils {
    public static final String WHITE_SPACE_CHARACTER = "&#x0020;";
    private static final Log log = LogFactory.getLog(ComponentUtils.class);
    private static final String VH_HEADER = "nuxeo-virtual-host";

    private ComponentUtils() {
    }

    public static void encodeComponent(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        component.encodeChildren(context);
        component.encodeEnd(context);
    }

    public static void initiateSubComponent(UIComponent parent, String facetName, UIComponent child) {
        parent.getFacets().put(facetName, child);
        child.setRendered(false);
    }

    public static UIComponent hookSubComponent(FacesContext context, UIComponent parent, UIComponent child, String defaultChildId) {
        String childId = child.getId();
        if (defaultChildId != null) {
            childId = defaultChildId;
        }
        if (childId == null) {
            childId = context.getViewRoot().createUniqueId();
        }
        child.setId(childId);
        child.setParent(parent);
        child.setRendered(true);
        return child;
    }

    public static void copyValues(UIComponent parent, UIComponent child, String[] valueNames) {
        Map parentAttributes = parent.getAttributes();
        Map childAttributes = child.getAttributes();
        for (String name : valueNames) {
            ValueExpression ve;
            if (parentAttributes.containsKey(name)) {
                childAttributes.put(name, parentAttributes.get(name));
            }
            if ((ve = parent.getValueExpression(name)) == null) continue;
            child.setValueExpression(name, ve);
        }
    }

    public static void copyLinkValues(UIComponent parent, UIComponent child) {
        String[] valueNames = new String[]{"accesskey", "charset", "coords", "dir", "disabled", "hreflang", "lang", "onblur", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "rel", "rev", "shape", "style", "styleClass", "tabindex", "target", "title", "type"};
        ComponentUtils.copyValues(parent, child, valueNames);
    }

    public static Object getAttributeValue(UIComponent component, String attributeName, Object defaultValue) {
        Object value = component.getAttributes().get(attributeName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static Object getAttributeOrExpressionValue(FacesContext context, UIComponent component, String attributeName, Object defaultValue) {
        Object value = component.getAttributes().get(attributeName);
        if (value == null) {
            ValueExpression schemaExpr = component.getValueExpression(attributeName);
            value = schemaExpr.getValue(context.getELContext());
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String download(FacesContext faces, Blob blob, String filename) {
        if (!faces.getResponseComplete()) {
            ExternalContext econtext = faces.getExternalContext();
            Map map = econtext.getRequestParameterMap();
            if (map != null && map.containsKey("AJAXREQUEST")) {
                return null;
            }
            if (blob == null) {
                log.error((Object)("No bytes available for the file: " + filename));
            } else {
                HttpServletRequest request;
                HttpServletResponse response = (HttpServletResponse)econtext.getResponse();
                if (filename == null || filename.length() == 0) {
                    filename = "file";
                }
                boolean inline = (request = (HttpServletRequest)econtext.getRequest()).getParameter("inline") != null;
                String userAgent = request.getHeader("User-Agent");
                String contentDisposition = RFC2231.encodeContentDisposition((String)filename, (boolean)inline, (String)userAgent);
                response.setHeader("Content-Disposition", contentDisposition);
                ComponentUtils.addCacheControlHeaders(request, response);
                log.debug((Object)("Downloading with mime/type : " + blob.getMimeType()));
                response.setContentType(blob.getMimeType());
                long fileSize = blob.getLength();
                if (fileSize > 0L) {
                    response.setContentLength((int)fileSize);
                }
                try {
                    blob.transferTo((OutputStream)response.getOutputStream());
                    response.flushBuffer();
                }
                catch (IOException e) {
                    log.error((Object)("Error while downloading the file: " + filename));
                }
                faces.responseComplete();
            }
        }
        return null;
    }

    private static void addCacheControlHeaders(HttpServletRequest request, HttpServletResponse response) {
        String nvh;
        String userAgent = request.getHeader("User-Agent");
        boolean secure = request.isSecure();
        if (!secure && (nvh = request.getHeader(VH_HEADER)) != null) {
            secure = nvh.startsWith("https");
        }
        log.debug((Object)("User-Agent: " + userAgent));
        log.debug((Object)("secure: " + secure));
        if (secure && userAgent.contains("MSIE")) {
            log.debug((Object)"Setting \"Cache-Control: max-age=15, must-revalidate\"");
            response.setHeader("Cache-Control", "max-age=15, must-revalidate");
        } else {
            log.debug((Object)"Setting \"Cache-Control: private\" and \"Pragma: no-cache\"");
            response.setHeader("Cache-Control", "private, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
        }
    }

    public static String translate(FacesContext context, String messageId) {
        return ComponentUtils.translate(context, messageId, null);
    }

    public static String translate(FacesContext context, String messageId, Object ... params) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        return I18NUtils.getMessageString((String)bundleName, (String)messageId, (Object[])params, (Locale)locale);
    }

    public static void addErrorMessage(FacesContext context, UIComponent component, String message) {
        ComponentUtils.addErrorMessage(context, component, message, null);
    }

    public static void addErrorMessage(FacesContext context, UIComponent component, String message, Object[] params) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        message = I18NUtils.getMessageString((String)bundleName, (String)message, (Object[])params, (Locale)locale);
        FacesMessage msg = new FacesMessage(message);
        msg.setSeverity(FacesMessage.SEVERITY_ERROR);
        context.addMessage(component.getClientId(context), msg);
    }

    public static UIComponent getBase(UIComponent anchor) {
        UIComponent base = anchor;
        boolean firstFound = false;
        while (base.getParent() != null) {
            if (base instanceof NamingContainer) {
                if (firstFound) break;
                firstFound = true;
            }
            base = base.getParent();
        }
        return base;
    }

    public static <T> T getComponent(UIComponent base, String componentId, Class<T> expectedComponentClass) {
        block6: {
            if (componentId == null) {
                log.error((Object)"Cannot retrieve component with a null id");
                return null;
            }
            try {
                UIComponent component = base.findComponent(componentId);
                if (component == null) {
                    log.error((Object)("Could not find component with id: " + componentId));
                    break block6;
                }
                try {
                    return (T)component;
                }
                catch (ClassCastException e) {
                    log.error((Object)String.format("Invalid component with id %s: %s, expected a component with interface %s", componentId, component, expectedComponentClass));
                }
            }
            catch (Exception e) {
                log.error((Object)("Error when trying to retrieve component with id " + componentId), (Throwable)e);
            }
        }
        return null;
    }
}

