/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.ui.web.util.BadDocumentUriException;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

@Deprecated
public final class DocumentLocator {
    public static final String URL_PREFIX = "getDocument.faces?";
    public static final String PARAM_NAME = "docRef";
    public static final String CHAR_ENCODING = "UTF-8";
    private static final Log log = LogFactory.getLog(DocumentLocator.class);

    private DocumentLocator() {
    }

    public static String getDocumentUrl(RepositoryLocation serverLocation, DocumentRef docRef) {
        if (serverLocation == null) {
            String nullRepoName = null;
            return DocumentLocator.getDocumentUrl(nullRepoName, docRef);
        }
        return DocumentLocator.getDocumentUrl(serverLocation.getName(), docRef);
    }

    public static String getDocumentUrl(String serverLocationName, DocumentRef docRef) {
        if (null == docRef) {
            throw new IllegalArgumentException("null docRef");
        }
        StringBuilder urlBuf = new StringBuilder();
        urlBuf.append(URL_PREFIX);
        urlBuf.append(PARAM_NAME);
        urlBuf.append('=');
        if (serverLocationName != null) {
            urlBuf.append(DocumentLocator.encode(serverLocationName));
        }
        urlBuf.append('/');
        urlBuf.append(docRef.type());
        urlBuf.append(':');
        urlBuf.append(DocumentLocator.encode(docRef.reference().toString()));
        return urlBuf.toString();
    }

    private static String encode(String txt) {
        String safetxt;
        try {
            safetxt = URLEncoder.encode(txt, CHAR_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        return safetxt;
    }

    private static String decode(String txt) {
        String decoded;
        try {
            decoded = URLDecoder.decode(txt, CHAR_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        return decoded;
    }

    public static String getFullDocumentUrl(RepositoryLocation serverLocation, DocumentRef docRef) {
        String baseUrl = BaseURL.getBaseURL();
        String docUrl = DocumentLocator.getDocumentUrl(serverLocation, docRef);
        if (baseUrl != null) {
            return baseUrl + docUrl;
        }
        return docUrl;
    }

    public static String getFullDocumentUrl(String serverLocation, DocumentRef docRef) {
        String baseUrl = BaseURL.getBaseURL();
        String docUrl = DocumentLocator.getDocumentUrl(serverLocation, docRef);
        if (baseUrl != null) {
            return baseUrl + docUrl;
        }
        return docUrl;
    }

    public static DocumentLocation parseDocRef(String docUriRef) throws BadDocumentUriException {
        IdRef docRef;
        int refType;
        int pos = docUriRef.indexOf(47);
        if (pos == -1) {
            throw new BadDocumentUriException("/ delimiter not found");
        }
        String serverLocation = docUriRef.substring(0, pos);
        String serverLocationName = serverLocation = DocumentLocator.decode(serverLocation);
        int pos2 = docUriRef.indexOf(58, pos + 1);
        if (pos2 == -1) {
            throw new BadDocumentUriException(": delimiter not found");
        }
        String refTypeStr = docUriRef.substring(pos + 1, pos2);
        try {
            refType = Integer.parseInt(refTypeStr);
        }
        catch (NumberFormatException e) {
            throw new BadDocumentUriException("bad refType (not a number) " + refTypeStr);
        }
        String reference = docUriRef.substring(pos2 + 1);
        reference = DocumentLocator.decode(reference);
        if (refType == 1) {
            docRef = new IdRef(reference);
        } else if (2 == refType) {
            docRef = new PathRef(reference);
        } else {
            throw new BadDocumentUriException("bad refType " + refType);
        }
        return new DocumentLocationImpl(serverLocationName, (DocumentRef)docRef);
    }
}

