/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectConnector;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.ConnectServerResponse;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.data.SubscriptionStatus;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.identity.SecurityHeaderGenerator;
import org.nuxeo.connect.update.PackageType;

public abstract class AbstractConnectConnector
implements ConnectConnector {
    public static final String GET_DOWNLOADS_SUFFIX = "getDownloads";
    public static final String GET_DOWNLOAD_SUFFIX = "getDownload";
    public static final String GET_STATUS_SUFFIX = "status";

    protected String getBaseUrl() {
        return ConnectUrlConfig.getRegistredBaseUrl();
    }

    protected ConnectServerResponse execCall(String url) throws ConnectServerError {
        Map<String, String> headers = SecurityHeaderGenerator.getHeaders();
        return this.execServerCall(url, headers);
    }

    protected abstract ConnectServerResponse execServerCall(String var1, Map<String, String> var2) throws ConnectServerError;

    @Override
    public SubscriptionStatus getConnectStatus() throws ConnectServerError {
        String url = this.getBaseUrl() + GET_STATUS_SUFFIX;
        ConnectServerResponse response = this.execCall(url);
        String json = response.getString();
        try {
            SubscriptionStatus subscriptionStatus = SubscriptionStatus.loadFromJSON(json);
            return subscriptionStatus;
        }
        catch (JSONException e) {
            throw new ConnectServerError("Unable to parse response", e);
        }
        finally {
            response.release();
        }
    }

    @Override
    public DownloadingPackage getDownload(String id) throws ConnectServerError {
        try {
            id = URLEncoder.encode(id, "UTF-8");
            id = id.replace("+", "%20");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String url = this.getBaseUrl() + GET_DOWNLOAD_SUFFIX + "/" + id;
        ConnectServerResponse response = this.execCall(url);
        String json = response.getString();
        try {
            PackageDescriptor pkg = PackageDescriptor.loadFromJSON(json);
            ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
            DownloadingPackage downloadingPackage = cdm.storeDownloadedBundle(pkg);
            return downloadingPackage;
        }
        catch (Exception e) {
            throw new ConnectServerError("Unable to parse response", e);
        }
        finally {
            response.release();
        }
    }

    @Override
    public List<DownloadablePackage> getDownloads(PackageType type) throws ConnectServerError {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        String url = this.getBaseUrl() + GET_DOWNLOADS_SUFFIX + "/" + type.getValue();
        ConnectServerResponse response = this.execCall(url);
        String json = response.getString();
        try {
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject ob = (JSONObject)array.get(i);
                result.add(PackageDescriptor.loadFromJSON(ob));
            }
            ArrayList<DownloadablePackage> arrayList = result;
            return arrayList;
        }
        catch (JSONException e) {
            throw new ConnectServerError("Unable to parse response", e);
        }
        finally {
            response.release();
        }
    }
}

