/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.data;

import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.Version;

public class PackageDescriptor
extends AbstractJSONSerializableData
implements DownloadablePackage {
    protected String homePage;
    protected String classifier;
    protected String description;
    protected String id;
    protected String name;
    protected String vendor;
    protected int state;
    protected String license;
    protected String licenseUrl;
    protected String[] targetPlatforms;
    protected PackageDependency[] dependencies;
    protected String title;
    protected PackageType type;
    protected Version version;
    protected String sourceDigest;
    protected String sourceUrl;
    protected long sourceSize;
    protected int commentsNumber;
    protected String pictureUrl;
    protected int downloadsCount;
    protected int rating;

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setCommentsNumber(int commentsNumber) {
        this.commentsNumber = commentsNumber;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public void setDownloadsCount(int downloadsCount) {
        this.downloadsCount = downloadsCount;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    @Override
    public String getHomePage() {
        return this.homePage;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public String getLicenseType() {
        return this.license;
    }

    @Override
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @Override
    public String[] getTargetPlatforms() {
        return this.targetPlatforms;
    }

    @Override
    public PackageDependency[] getDependencies() {
        if (this.dependencies == null) {
            return new PackageDependency[0];
        }
        return this.dependencies;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public PackageType getType() {
        return this.type;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public String getSourceDigest() {
        return this.sourceDigest;
    }

    @Override
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @Override
    public long getSourceSize() {
        return this.sourceSize;
    }

    @Override
    public JSONObject asJSON() {
        String[] names = new String[]{"id", "getHomePage", "sourceSize", "sourceUrl", "classifier", "description", "name", "state", "title", "version", "type", "sourceDigest", "targetPlatform", "commentsNumber", "rating", "pictureUrl", "downloadsCount"};
        JSONObject json = new JSONObject((Object)this);
        String jsonString = json.toString();
        JSONArray deps = new JSONArray();
        for (PackageDependency dep : this.getDependencies()) {
            deps.put((Object)dep.toString());
        }
        try {
            json.put("dependencies", (Object)deps);
        }
        catch (JSONException e) {
            // empty catch block
        }
        return json;
    }

    public static PackageDescriptor loadFromJSON(JSONObject json) throws JSONException {
        int i;
        JSONArray array;
        PackageDescriptor bundle = new PackageDescriptor();
        bundle.id = json.getString("id");
        if (json.has("homePage")) {
            bundle.homePage = json.getString("homePage");
        }
        if (json.has("classifier")) {
            bundle.classifier = json.getString("classifier");
        }
        if (json.has("description")) {
            bundle.description = json.getString("description");
        }
        if (json.has("name")) {
            bundle.name = json.getString("name");
        }
        if (json.has("state")) {
            bundle.state = json.getInt("state");
        }
        if (json.has("title")) {
            bundle.title = json.getString("title");
        }
        if (json.has("version")) {
            bundle.version = new Version(json.getString("version"));
        }
        if (json.has("type")) {
            bundle.type = PackageType.getByValue(json.getString("type"));
        }
        if (json.has("sourceUrl")) {
            bundle.sourceUrl = json.getString("sourceUrl");
        }
        if (json.has("sourceDigest")) {
            bundle.sourceDigest = json.getString("sourceDigest");
        }
        if (json.has("sourceSize")) {
            bundle.sourceSize = json.getLong("sourceSize");
        }
        if (json.has("commentsNumber")) {
            bundle.commentsNumber = json.getInt("commentsNumber");
        }
        if (json.has("rating")) {
            bundle.rating = json.getInt("rating");
        }
        if (json.has("downloadsCount")) {
            bundle.downloadsCount = json.getInt("downloadsCount");
        }
        if (json.has("pictureUrl")) {
            bundle.pictureUrl = json.getString("pictureUrl");
        }
        if (json.has("targetPlatforms")) {
            array = json.getJSONArray("targetPlatforms");
            String[] targets = new String[array.length()];
            for (i = 0; i < array.length(); ++i) {
                targets[i] = array.getString(i);
            }
            bundle.targetPlatforms = targets;
        }
        if (json.has("dependencies")) {
            array = json.getJSONArray("dependencies");
            PackageDependency[] deps = new PackageDependency[array.length()];
            for (i = 0; i < array.length(); ++i) {
                deps[i] = new PackageDependency(array.getString(i));
            }
            bundle.dependencies = deps;
        }
        return bundle;
    }

    public static PackageDescriptor loadFromJSON(String json) throws JSONException {
        return PackageDescriptor.loadFromJSON(new JSONObject(json));
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTargetPlatforms(List<String> targetPlatforms) {
        this.targetPlatforms = targetPlatforms == null ? new String[]{} : targetPlatforms.toArray(new String[targetPlatforms.size()]);
    }

    public void setTargetPlatforms(String[] targetPlatforms) {
        this.targetPlatforms = targetPlatforms;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(PackageType type) {
        this.type = type;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void setSourceDigest(String sourceDigest) {
        this.sourceDigest = sourceDigest;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public void setSourceSize(long sourceSize) {
        this.sourceSize = sourceSize;
    }

    public void setDependencies(PackageDependency[] dependencies) {
        this.dependencies = dependencies;
    }

    public String getDependenciesAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.dependencies == null || this.dependencies.length == 0) {
            return "";
        }
        for (PackageDependency dep : this.getDependencies()) {
            sb.append(dep.toString());
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public int getCommentsNumber() {
        return this.commentsNumber;
    }

    @Override
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @Override
    public int getRating() {
        return this.rating;
    }

    @Override
    public int getDownloadsCount() {
        return this.downloadsCount;
    }
}

