/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.data;

import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.SubscriptionStatusType;

public class SubscriptionStatus
extends AbstractJSONSerializableData {
    protected String contractStatus;
    protected String endDate;
    protected String message;
    protected String description;
    protected NuxeoClientInstanceType instanceType;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NuxeoClientInstanceType getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(NuxeoClientInstanceType instanceType) {
        this.instanceType = instanceType;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getContractStatus() {
        return this.contractStatus;
    }

    public SubscriptionStatusType status() {
        return SubscriptionStatusType.getByValue(this.contractStatus);
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public static SubscriptionStatus loadFromJSON(JSONObject ob) throws JSONException {
        SubscriptionStatus status = new SubscriptionStatus();
        status.contractStatus = ob.getString("contractStatus");
        if (ob.has("description")) {
            status.description = ob.getString("description");
        }
        if (ob.has("message")) {
            status.message = ob.getString("message");
        }
        if (ob.has("endDate")) {
            status.endDate = ob.getString("endDate");
        }
        if (ob.has("errorMessage")) {
            status.errorMessage = ob.getString("errorMessage");
        }
        if (ob.has("instanceType")) {
            status.instanceType = NuxeoClientInstanceType.fromString(ob.getString("instanceType"));
        }
        return status;
    }

    public static SubscriptionStatus loadFromJSON(String json) throws JSONException {
        JSONObject ob = new JSONObject(json);
        return SubscriptionStatus.loadFromJSON(ob);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isError()) {
            sb.append("Error : ");
            sb.append(this.errorMessage);
            sb.append("\n");
        }
        sb.append(this.contractStatus);
        sb.append("\n");
        sb.append(this.endDate);
        sb.append("\n");
        sb.append(this.message);
        sb.append("\n");
        return sb.toString();
    }
}

