/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.packages.DownloadingPackageSource;
import org.nuxeo.connect.packages.LocalPackageSource;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.RemotePackageSource;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.task.Task;

public class PackageManagerImpl
implements PackageManager {
    protected static final Log log = LogFactory.getLog(PackageManagerImpl.class);
    protected List<PackageSource> localSources = new ArrayList<PackageSource>();
    protected List<PackageSource> remoteSources = new ArrayList<PackageSource>();
    protected List<String> sourcesNames = new ArrayList<String>();
    protected Map<String, DownloadablePackage> cachedPackageList = null;

    protected List<PackageSource> getAllSources() {
        ArrayList<PackageSource> allSources = new ArrayList<PackageSource>();
        allSources.addAll(this.remoteSources);
        allSources.addAll(this.localSources);
        return allSources;
    }

    public PackageManagerImpl() {
        this.registerSource(new RemotePackageSource(), false);
        this.registerSource(new DownloadingPackageSource(), true);
        this.registerSource(new LocalPackageSource(), true);
    }

    public void resetSources() {
        this.localSources.clear();
        this.remoteSources.clear();
        this.sourcesNames.clear();
        if (this.cachedPackageList != null) {
            this.cachedPackageList.clear();
        }
    }

    protected List<DownloadablePackage> doMergePackages(List<PackageSource> sources, PackageType type) {
        HashMap<String, DownloadablePackage> packagesById = new HashMap<String, DownloadablePackage>();
        for (PackageSource source : sources) {
            List<DownloadablePackage> packages = null;
            packages = type == null ? source.listPackages() : source.listPackages(type);
            for (DownloadablePackage pkg : packages) {
                packagesById.put(pkg.getId(), pkg);
            }
        }
        ArrayList allPackages = new ArrayList();
        allPackages.addAll(packagesById.values());
        HashMap<String, DownloadablePackage> packagesByName = new HashMap<String, DownloadablePackage>();
        for (DownloadablePackage pkg : allPackages) {
            String name = pkg.getName();
            if (packagesByName.containsKey(name)) {
                DownloadablePackage other = (DownloadablePackage)packagesByName.get(name);
                if (!pkg.getVersion().greaterThan(other.getVersion())) continue;
                packagesByName.put(name, pkg);
                continue;
            }
            packagesByName.put(name, pkg);
        }
        ArrayList<DownloadablePackage> resPackages = new ArrayList<DownloadablePackage>();
        resPackages.addAll(packagesByName.values());
        return resPackages;
    }

    @Override
    public List<DownloadablePackage> listPackages() {
        return this.doMergePackages(this.getAllSources(), null);
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType type) {
        return this.doMergePackages(this.getAllSources(), type);
    }

    @Override
    public List<DownloadablePackage> searchPackages(String searchExpr) {
        return null;
    }

    @Override
    public void registerSource(PackageSource source, boolean local) {
        String name = source.getName();
        if (!this.sourcesNames.contains(name)) {
            if (local) {
                this.localSources.add(source);
            } else {
                this.remoteSources.add(source);
            }
        }
    }

    @Override
    public List<DownloadablePackage> listRemotePackages() {
        return this.doMergePackages(this.remoteSources, null);
    }

    @Override
    public List<DownloadablePackage> listRemotePackages(PackageType type) {
        return this.doMergePackages(this.remoteSources, type);
    }

    @Override
    public List<DownloadablePackage> listLocalPackages() {
        return this.doMergePackages(this.localSources, null);
    }

    @Override
    public List<DownloadablePackage> listLocalPackages(PackageType type) {
        return this.doMergePackages(this.localSources, type);
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages() {
        return this.listUpdatePackages(null);
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages(PackageType type) {
        List<DownloadablePackage> localPackages = this.listLocalPackages(type);
        List<DownloadablePackage> remotePackages = this.listRemotePackages(type);
        ArrayList<DownloadablePackage> toUpdate = new ArrayList<DownloadablePackage>();
        ArrayList<String> toUpdateIds = new ArrayList<String>();
        for (DownloadablePackage pkg : localPackages) {
            for (DownloadablePackage remotePkg : remotePackages) {
                if (!remotePkg.getName().equals(pkg.getName())) continue;
                if (remotePkg.getVersion() != null) {
                    if (!remotePkg.getVersion().greaterThan(pkg.getVersion())) continue;
                    toUpdate.add(remotePkg);
                    toUpdateIds.add(remotePkg.getId());
                    continue;
                }
                log.warn((Object)("Package " + remotePkg.getId() + " has a null version"));
            }
        }
        List<DownloadablePackage> hotFixes = this.listRemotePackages(PackageType.HOT_FIX);
        for (DownloadablePackage pkg : hotFixes) {
            if (toUpdateIds.contains(pkg.getId())) continue;
            toUpdate.add(0, pkg);
        }
        return toUpdate;
    }

    @Override
    public DownloadingPackage download(String packageId) throws Exception {
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        return crs.getConnector().getDownload(packageId);
    }

    @Override
    public void install(String packageId, Map<String, String> params) throws Exception {
        PackageUpdateService pus = NuxeoConnectClient.getPackageUpdateService();
        if (pus == null) {
            if (!NuxeoConnectClient.isTestModeSet()) {
                log.error((Object)"Can not locate PackageUpdateService, exiting");
            }
            return;
        }
        LocalPackage pkg = pus.getPackage(packageId);
        Task installationTask = pkg.getInstallTask();
        installationTask.validate();
        installationTask.run(params);
    }

    protected void invalidateCache() {
        this.cachedPackageList = null;
    }

    protected Map<String, DownloadablePackage> getCachedPackageList() {
        if (this.cachedPackageList == null) {
            this.cachedPackageList = new HashMap<String, DownloadablePackage>();
        }
        for (DownloadablePackage pkg : this.listPackages()) {
            this.cachedPackageList.put(pkg.getId(), pkg);
        }
        return this.cachedPackageList;
    }

    protected DownloadablePackage getPkgInList(List<DownloadablePackage> pkgs, String pkgId) {
        for (DownloadablePackage pkg : pkgs) {
            if (!pkgId.equals(pkg.getId())) continue;
            return pkg;
        }
        return null;
    }

    @Override
    public DownloadablePackage getLocalPackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listLocalPackages();
        return this.getPkgInList(pkgs, pkgId);
    }

    @Override
    public DownloadablePackage getRemotePackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listRemotePackages();
        return this.getPkgInList(pkgs, pkgId);
    }

    @Override
    public DownloadablePackage getPackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listPackages();
        DownloadablePackage pkg = this.getPkgInList(pkgs, pkgId);
        if (pkg == null) {
            List<DownloadablePackage> studioPkgs = this.listAllStudioRemotePackages();
            pkg = this.getPkgInList(studioPkgs, pkgId);
        }
        return pkg;
    }

    @Override
    public List<DownloadablePackage> listRemoteOrLocalPackages() {
        return this.listRemoteOrLocalPackages(null);
    }

    @Override
    public List<DownloadablePackage> listRemoteOrLocalPackages(PackageType type) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        List<DownloadablePackage> all = this.listPackages(type);
        List<DownloadablePackage> remotes = this.listRemotePackages(type);
        block0: for (DownloadablePackage pkg : all) {
            for (DownloadablePackage remote : remotes) {
                if (!remote.getName().equals(pkg.getName())) continue;
                result.add(pkg);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listAllStudioRemoteOrLocalPackages() {
        List<DownloadablePackage> remote = this.listAllStudioRemotePackages();
        List<DownloadablePackage> local = this.listLocalPackages(PackageType.STUDIO);
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : remote) {
            boolean found = false;
            for (DownloadablePackage lpkg : local) {
                if (!lpkg.getId().equals(pkg.getId())) continue;
                result.add(lpkg);
                found = true;
                break;
            }
            if (found) continue;
            result.add(pkg);
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listOnlyRemotePackages() {
        return this.listOnlyRemotePackages(null);
    }

    @Override
    public List<DownloadablePackage> listOnlyRemotePackages(PackageType type) {
        List<DownloadablePackage> result = this.listRemotePackages(type);
        List<DownloadablePackage> local = this.listLocalPackages(type);
        block0: for (DownloadablePackage pkg : local) {
            for (DownloadablePackage remote : result) {
                if (!remote.getName().equals(pkg.getName())) continue;
                result.remove(remote);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listAllStudioRemotePackages() {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (PackageSource source : this.remoteSources) {
            List<DownloadablePackage> packages = source.listPackages(PackageType.STUDIO);
            result.addAll(packages);
        }
        return result;
    }

    @Override
    public void flushCache() {
        for (PackageSource source : this.getAllSources()) {
            source.flushCache();
        }
    }
}

