/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management;

import org.nuxeo.ecm.core.management.api.AdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.GlobalAdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.ProbeManager;
import org.nuxeo.ecm.core.management.probes.ProbeDescriptor;
import org.nuxeo.ecm.core.management.probes.ProbeManagerImpl;
import org.nuxeo.ecm.core.management.statuses.AdministrableServiceDescriptor;
import org.nuxeo.ecm.core.management.statuses.AdministrativeStatusManagerImpl;
import org.nuxeo.ecm.core.management.statuses.GlobalAdministrativeStatusManagerImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class CoreManagementComponent
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName(CoreManagementComponent.class.getCanonicalName());
    public static final String PROBES_EP = "probes";
    public static final String SERVICE_DEF_EP = "serviceDefinition";
    protected GlobalAdministrativeStatusManagerImpl globalManager = new GlobalAdministrativeStatusManagerImpl();
    protected ProbeManagerImpl probeRunner = new ProbeManagerImpl();

    protected AdministrativeStatusManagerImpl getLocalManager() {
        return (AdministrativeStatusManagerImpl)this.globalManager.getStatusManager(this.globalManager.getLocalNuxeoInstanceIdentifier());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(GlobalAdministrativeStatusManager.class)) {
            return adapter.cast(this.globalManager);
        }
        if (adapter.isAssignableFrom(AdministrativeStatusManager.class)) {
            return adapter.cast(this.getLocalManager());
        }
        if (adapter.isAssignableFrom(ProbeManager.class)) {
            return adapter.cast(this.probeRunner);
        }
        return (T)super.getAdapter(adapter);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(PROBES_EP)) {
            this.probeRunner.registerProbe((ProbeDescriptor)contribution);
        } else if (extensionPoint.equals(SERVICE_DEF_EP)) {
            this.globalManager.registerService((AdministrableServiceDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(PROBES_EP)) {
            this.probeRunner.unregisterProbe((ProbeDescriptor)contribution);
        }
    }

    public void activate(ComponentContext context) throws Exception {
        context.getRuntimeContext().getBundle().getBundleContext().addFrameworkListener(new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                event.getBundle().getBundleContext().removeFrameworkListener((FrameworkListener)this);
                ClassLoader jbossCL = Thread.currentThread().getContextClassLoader();
                ClassLoader nuxeoCL = Framework.class.getClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(nuxeoCL);
                    CoreManagementComponent.this.getLocalManager().onNuxeoServerStartup();
                    CoreManagementComponent.this.probeRunner.runAllProbes();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(jbossCL);
                }
            }
        });
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.getLocalManager().onNuxeoServerShutdown();
    }
}

