/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.storage;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.management.api.AdministrativeStatus;
import org.nuxeo.ecm.core.management.storage.AdministrativeStatusPersister;
import org.nuxeo.ecm.core.management.storage.StatusFetcher;
import org.nuxeo.runtime.api.Framework;

public class DocumentModelStatusPersister
implements AdministrativeStatusPersister {
    public static final String ADMINISTRATIVE_INFO_CONTAINER = "administrative-infos";
    public static final String ADMINISTRATIVE_INFO_CONTAINER_DOCUMENT_TYPE = "AdministrativeStatusContainer";
    public static final String ADMINISTRATIVE_STATUS_DOCUMENT_TYPE = "AdministrativeStatus";
    public static final String STATUS_PROPERTY = "status:administrative_status";
    public static final String MESSAGE_PROPERTY = "status:statusMessage";
    public static final String INSTANCE_PROPERTY = "status:instanceId";
    public static final String SERVICE_PROPERTY = "status:serviceId";
    public static final String LOGIN_PROPERTY = "status:userLogin";
    private static final Log log = LogFactory.getLog(DocumentModelStatusPersister.class);
    protected String repositoryName;

    protected String getRepositoryName() {
        if (this.repositoryName == null) {
            this.repositoryName = ((RepositoryManager)Framework.getLocalService(RepositoryManager.class)).getDefaultRepository().getName();
        }
        return this.repositoryName;
    }

    protected String getAdministrativeStatusDocName(AdministrativeStatus status) {
        return status.getInstanceIdentifier() + "--" + status.getServiceIdentifier();
    }

    @Override
    public List<String> getAllInstanceIds() {
        StatusFetcher fetcher = new StatusFetcher(this.getRepositoryName(), null, null);
        try {
            fetcher.runUnrestricted();
            return fetcher.allInstanceIds;
        }
        catch (ClientException e) {
            log.error((Object)"Error while fetching all instance Ids", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<AdministrativeStatus> getAllStatuses(String instanceId) {
        StatusFetcher fetcher = new StatusFetcher(this.getRepositoryName(), instanceId, null);
        try {
            fetcher.runUnrestricted();
            return fetcher.statuses;
        }
        catch (ClientException e) {
            log.error((Object)("Error while fetching all service status for instance " + instanceId), (Throwable)e);
            return null;
        }
    }

    @Override
    public AdministrativeStatus getStatus(String instanceId, String serviceIdentifier) {
        StatusFetcher fetcher = new StatusFetcher(this.getRepositoryName(), instanceId, serviceIdentifier);
        try {
            fetcher.runUnrestricted();
            if (fetcher.statuses.size() == 1) {
                return fetcher.statuses.get(0);
            }
            log.warn((Object)("Unable to fetch status for service " + serviceIdentifier + " in instance " + instanceId));
            return null;
        }
        catch (ClientException e) {
            log.error((Object)("Error while fetching all service status for instance " + instanceId), (Throwable)e);
            return null;
        }
    }

    @Override
    public void remove(String instanceId) {
        throw new UnsupportedOperationException("Not implemented for now");
    }

    @Override
    public AdministrativeStatus saveStatus(AdministrativeStatus status) {
        try {
            StatusSaver saver = new StatusSaver(this.getRepositoryName(), status);
            saver.runUnrestricted();
            return saver.getStatus();
        }
        catch (Exception e) {
            log.error((Object)"Error while saving status", (Throwable)e);
            return null;
        }
    }

    private class StatusSaver
    extends UnrestrictedSessionRunner {
        protected AdministrativeStatus status;

        public StatusSaver(String repoName, AdministrativeStatus status) {
            super(repoName);
            this.status = status;
        }

        public void run() throws ClientException {
            DocumentModel doc = this.doGetOrCreateDoc(this.status);
            this.session.save();
        }

        public AdministrativeStatus getStatus() {
            return this.status;
        }

        protected DocumentModel doGetOrCreateContainer() throws ClientException {
            PathRef admRootDocRef = new PathRef("/administrative-infos");
            if (!this.session.exists((DocumentRef)admRootDocRef)) {
                DocumentModel doc = this.session.createDocumentModel("/", DocumentModelStatusPersister.ADMINISTRATIVE_INFO_CONTAINER, DocumentModelStatusPersister.ADMINISTRATIVE_INFO_CONTAINER_DOCUMENT_TYPE);
                doc.setPropertyValue("dc:title", (Serializable)((Object)DocumentModelStatusPersister.ADMINISTRATIVE_INFO_CONTAINER));
                doc = this.session.createDocument(doc);
                this.session.save();
            }
            return this.session.getDocument((DocumentRef)admRootDocRef);
        }

        protected DocumentModel doGetOrCreateDoc(AdministrativeStatus status) throws ClientException {
            DocumentModel administrativeContainer = this.doGetOrCreateContainer();
            PathRef statusDocRef = new PathRef(administrativeContainer.getPathAsString() + "/" + DocumentModelStatusPersister.this.getAdministrativeStatusDocName(status));
            DocumentModel doc = null;
            boolean create = false;
            if (!this.session.exists((DocumentRef)statusDocRef)) {
                create = true;
                doc = this.session.createDocumentModel(administrativeContainer.getPathAsString(), DocumentModelStatusPersister.this.getAdministrativeStatusDocName(status), DocumentModelStatusPersister.ADMINISTRATIVE_STATUS_DOCUMENT_TYPE);
            } else {
                doc = this.session.getDocument((DocumentRef)statusDocRef);
            }
            doc.setPropertyValue(DocumentModelStatusPersister.LOGIN_PROPERTY, (Serializable)((Object)status.getUserLogin()));
            doc.setPropertyValue(DocumentModelStatusPersister.INSTANCE_PROPERTY, (Serializable)((Object)status.getInstanceIdentifier()));
            doc.setPropertyValue(DocumentModelStatusPersister.SERVICE_PROPERTY, (Serializable)((Object)status.getServiceIdentifier()));
            doc.setPropertyValue(DocumentModelStatusPersister.MESSAGE_PROPERTY, (Serializable)((Object)status.getMessage()));
            doc.setPropertyValue(DocumentModelStatusPersister.STATUS_PROPERTY, (Serializable)((Object)status.getState()));
            doc.setPropertyValue("dc:title", (Serializable)((Object)DocumentModelStatusPersister.this.getAdministrativeStatusDocName(status)));
            doc = create ? this.session.createDocument(doc) : this.session.saveDocument(doc);
            this.session.save();
            return doc;
        }
    }
}

