/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.storage;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.management.api.AdministrativeStatus;

public class StatusFetcher
extends UnrestrictedSessionRunner {
    protected String instanceId;
    protected String serviceId;
    protected List<String> allInstanceIds = new ArrayList<String>();
    protected List<AdministrativeStatus> statuses = new ArrayList<AdministrativeStatus>();

    public StatusFetcher(String repositoryName, String instanceId, String serviceId) {
        super(repositoryName);
        this.instanceId = instanceId;
        this.serviceId = serviceId;
    }

    public void run() throws ClientException {
        boolean onlyFetchIds = false;
        StringBuffer sb = new StringBuffer("select * from ");
        sb.append("AdministrativeStatus");
        if (this.instanceId == null) {
            onlyFetchIds = true;
        } else {
            sb.append(" where ");
            sb.append("status:instanceId");
            sb.append("='");
            sb.append(this.instanceId);
            sb.append("'");
            if (this.serviceId != null) {
                sb.append(" AND ");
                sb.append("status:serviceId");
                sb.append("='");
                sb.append(this.serviceId);
                sb.append("'");
            }
        }
        DocumentModelList result = this.session.query(sb.toString());
        for (DocumentModel doc : result) {
            if (onlyFetchIds) {
                String id = (String)((Object)doc.getPropertyValue("status:instanceId"));
                if (this.allInstanceIds.contains(id)) continue;
                this.allInstanceIds.add(id);
                continue;
            }
            this.statuses.add(this.wrap(doc));
        }
    }

    protected AdministrativeStatus wrap(DocumentModel doc) throws ClientException {
        String userLogin = (String)((Object)doc.getPropertyValue("status:userLogin"));
        String id = (String)((Object)doc.getPropertyValue("status:instanceId"));
        String service = (String)((Object)doc.getPropertyValue("status:serviceId"));
        String message = (String)((Object)doc.getPropertyValue("status:statusMessage"));
        String state = (String)((Object)doc.getPropertyValue("status:administrative_status"));
        Calendar modified = (Calendar)doc.getPropertyValue("dc:modified");
        AdministrativeStatus status = new AdministrativeStatus(state, message, modified, userLogin, id, service);
        return status;
    }
}

