/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.bulkedit;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.bulkedit.BulkEditHelper;
import org.nuxeo.ecm.webapp.bulkedit.FictiveDocumentModel;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;

@Name(value="bulkEditActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class BulkEditActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient TypeManager typeManager;
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected DocumentModel fictiveDocumentModel;

    public List<String> getCommonsLayouts() {
        if (this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            return Collections.emptyList();
        }
        List<DocumentModel> selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        return BulkEditHelper.getCommonLayouts(this.typeManager, selectedDocuments);
    }

    protected List<String> getCommonSchemas() {
        if (this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            return Collections.emptyList();
        }
        List<DocumentModel> selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        return BulkEditHelper.getCommonSchemas(selectedDocuments);
    }

    @Factory(value="bulkEditDocumentModel", scope=ScopeType.EVENT)
    public DocumentModel getBulkEditDocumentModel() {
        if (this.fictiveDocumentModel == null) {
            this.fictiveDocumentModel = FictiveDocumentModel.createFictiveDocumentModelWith(this.getCommonSchemas());
        }
        return this.fictiveDocumentModel;
    }

    public String bulkEditSelection() throws ClientException {
        this.bulkEditSelectionNoRedirect();
        return this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument());
    }

    public void bulkEditSelectionNoRedirect() throws ClientException {
        if (this.fictiveDocumentModel != null) {
            List<DocumentModel> selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            BulkEditHelper.copyMetadata(this.documentManager, this.fictiveDocumentModel, selectedDocuments);
            this.fictiveDocumentModel = null;
        }
    }

    public void cancel() {
        this.fictiveDocumentModel = null;
    }
}

