/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.util.List;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PageProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentView;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentViewCache;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentViewService;

@Name(value="contentViewActions")
@Scope(value=ScopeType.CONVERSATION)
public class ContentViewActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected ContentViewService contentViewService;
    @In(create=true, required=true)
    protected transient CoreSession documentManager;
    protected final ContentViewCache cache = new ContentViewCache();
    protected Long globalPageSize;
    @In(create=true, required=false)
    protected FacesContext facesContext;
    protected ContentView currentContentView;

    public ContentView getCurrentContentView() {
        return this.currentContentView;
    }

    public void setCurrentContentView(ContentView cv) {
        this.currentContentView = cv;
    }

    public Long getCurrentGlobalPageSize() {
        PageProvider pp;
        if (this.globalPageSize == null && this.currentContentView != null && (pp = this.currentContentView.getCurrentPageProvider()) != null) {
            return pp.getPageSize();
        }
        return this.globalPageSize;
    }

    public void setCurrentGlobalPageSize(Long pageSize) {
        this.globalPageSize = pageSize;
    }

    public Long getGlobalPageSize() {
        return this.globalPageSize;
    }

    public void setGlobalPageSize(Long pageSize) {
        this.globalPageSize = pageSize;
    }

    public ContentView getContentView(String name) throws ClientException {
        return this.getContentView(name, null);
    }

    public ContentView getContentView(String name, DocumentModel searchDocumentModel) throws ClientException {
        ContentView cView = this.cache.get(name);
        if (cView == null && (cView = this.contentViewService.getContentView(name)) != null) {
            this.cache.add(cView);
        }
        if (cView != null) {
            if (searchDocumentModel != null) {
                cView.setSearchDocumentModel(searchDocumentModel);
            } else {
                String docType;
                DocumentModel doc = cView.getSearchDocumentModel();
                if (doc == null && (docType = cView.getSearchDocumentModelType()) != null) {
                    DocumentModel blankDoc = this.documentManager.createDocumentModel(docType);
                    cView.setSearchDocumentModel(blankDoc);
                }
            }
            this.setCurrentContentView(cView);
        }
        return cView;
    }

    public ContentView getContentViewWithProvider(String name) throws ClientException {
        return this.getContentViewWithProvider(name, null, null, null, (Object[])null);
    }

    public ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel) throws ClientException {
        return this.getContentViewWithProvider(name, searchDocumentModel, null, null, (Object[])null);
    }

    public ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel, Object ... params) throws ClientException {
        return this.getContentViewWithProvider(name, searchDocumentModel, null, null, params);
    }

    public ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel, List<SortInfo> sortInfos, Long currentPage, Object ... params) throws ClientException {
        ContentView cView = this.getContentView(name, searchDocumentModel);
        if (cView != null) {
            Long pageSize = null;
            if (cView.getUseGlobalPageSize()) {
                pageSize = this.globalPageSize;
            }
            cView.getPageProvider(searchDocumentModel, sortInfos, pageSize, currentPage, params);
        }
        return cView;
    }

    public void refreshOnSeamEvent(String seamEventName) {
        this.cache.refreshOnEvent(seamEventName);
    }

    @Observer(value={"documentChildrenChanged", "documentChanged"})
    public void refreshOnDocumentChildrenChanged() {
        this.refreshOnSeamEvent("documentChildrenChanged");
        this.refreshOnSeamEvent("documentChanged");
    }

    public void refresh(String contentViewName) {
        this.cache.refresh(contentViewName);
    }

    public void reset(String contentViewName) {
        this.cache.reset(contentViewName);
    }
}

