/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.DocumentsPageProvider;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.platform.ui.web.api.ResultsProviderFarm;
import org.nuxeo.ecm.platform.ui.web.pagination.ResultsProviderFarmUserException;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentChildrenSearchFarm;

@Name(value="documentChildrenFarm")
@Scope(value=ScopeType.SESSION)
public class DocumentChildrenStdFarm
extends InputController
implements ResultsProviderFarm,
Serializable {
    public static final String CHILDREN_BY_COREAPI = "CURRENT_DOC_CHILDREN";
    private static final long serialVersionUID = 8609573595065569339L;
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    @In(create=true)
    private DocumentChildrenSearchFarm documentChildrenSearchFarm;

    public PagedDocumentsProvider getResultsProvider(String name, SortInfo sortInfo) throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (CHILDREN_BY_COREAPI.equals(name)) {
            boolean browseViaSearch = currentDoc.hasFacet("BrowseViaSearch");
            PagedDocumentsProvider provider = browseViaSearch ? this.documentChildrenSearchFarm.getResultsProvider(name, sortInfo) : this.getResProviderForDocChildren(currentDoc.getRef());
            provider.setName(name);
            return provider;
        }
        throw new ClientException("Unknown (or not supported) provider: " + name);
    }

    private PagedDocumentsProvider getResProviderForDocChildren(DocumentRef docRef) throws ClientException {
        FacetFilter facetFilter = new FacetFilter("HiddenInNavigation", false);
        LifeCycleFilter lifeCycleFilter = new LifeCycleFilter("deleted", false);
        CompoundFilter filter = new CompoundFilter(new Filter[]{facetFilter, lifeCycleFilter});
        DocumentModelIterator resultDocsIt = this.documentManager.getChildrenIterator(docRef, null, "Read", (Filter)filter);
        return new DocumentsPageProvider(resultDocsIt, 10);
    }

    public PagedDocumentsProvider getResultsProvider(String name) throws ClientException, ResultsProviderFarmUserException {
        return this.getResultsProvider(name, null);
    }
}

