/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.contentview.ContentView;
import org.nuxeo.ecm.webapp.contentbrowser.ContentViewActions;
import org.nuxeo.ecm.webapp.contentbrowser.ContentViewHeader;

@Name(value="documentContentViewActions")
@Scope(value=ScopeType.CONVERSATION)
public class DocumentContentViewActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient ContentViewActions contentViewActions;
    protected Map<String, Map<String, List<ContentViewHeader>>> typeToContentView = new HashMap<String, Map<String, List<ContentViewHeader>>>();
    protected Map<String, List<ContentViewHeader>> currentAvailableContentViews;

    protected List<ContentViewHeader> getContentViewHeaders(TypeInfo typeInfo, String category) throws ClientException {
        ArrayList<ContentViewHeader> res = new ArrayList<ContentViewHeader>();
        String[] cvNames = typeInfo.getContentViews(category);
        if (cvNames != null) {
            for (String cvName : cvNames) {
                ContentView cv = this.contentViewActions.getContentView(cvName);
                if (cv == null) continue;
                res.add(new ContentViewHeader(cvName, cv.getTitle(), cv.getTranslateTitle(), cv.getIconPath()));
            }
        }
        return res;
    }

    public boolean hasContentViewSupport(DocumentModel doc, String category) throws ClientException {
        Map<Object, Object> byCategories;
        if (doc == null) {
            return false;
        }
        String docType = doc.getType();
        if (!this.typeToContentView.containsKey(docType)) {
            byCategories = new HashMap();
            this.typeToContentView.put(docType, byCategories);
        }
        if (!this.typeToContentView.get(docType).containsKey(category)) {
            byCategories = this.typeToContentView.get(docType);
            TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
            byCategories.put(category, this.getContentViewHeaders(typeInfo, category));
            this.typeToContentView.put(docType, byCategories);
        }
        return !this.typeToContentView.get(docType).get(category).isEmpty();
    }

    public List<ContentViewHeader> getAvailableContentViewsForDocument(DocumentModel doc, String category) throws ClientException {
        if (doc == null || !this.hasContentViewSupport(doc, category)) {
            return Collections.emptyList();
        }
        return this.typeToContentView.get(doc.getType()).get(category);
    }

    public List<ContentViewHeader> getAvailableContentViewsForCurrentDocument(String category) throws ClientException {
        if (this.currentAvailableContentViews == null || !this.currentAvailableContentViews.containsKey(category)) {
            if (this.currentAvailableContentViews == null) {
                this.currentAvailableContentViews = new HashMap<String, List<ContentViewHeader>>();
            }
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.currentAvailableContentViews.put(category, this.getAvailableContentViewsForDocument(currentDocument, category));
        }
        return this.currentAvailableContentViews.get(category);
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false, inject=false)
    @BypassInterceptors
    public void documentChanged() {
        this.currentAvailableContentViews = null;
    }
}

