/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.delegate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.ejb.EJBAccessException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.contexts.Lifecycle;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.runtime.api.Framework;

@Name(value="documentManager")
@Scope(value=ScopeType.CONVERSATION)
public class DocumentManagerBusinessDelegate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentManagerBusinessDelegate.class);
    protected final Map<RepositoryLocation, CoreSession> sessions = new HashMap<RepositoryLocation, CoreSession>();

    public void initialize() {
        log.debug((Object)"Seam component initialized...");
    }

    @Unwrap
    public CoreSession getDocumentManager() throws ClientException {
        RepositoryLocation currentServerLocation = (RepositoryLocation)Component.getInstance((String)"currentServerLocation");
        return this.getDocumentManager(currentServerLocation);
    }

    public CoreSession getDocumentManager(RepositoryLocation serverLocation) throws ClientException {
        if (serverLocation == null) {
            return null;
        }
        CoreSession session = this.sessions.get(serverLocation);
        if (session == null) {
            if (Lifecycle.isDestroying()) {
                return null;
            }
            String serverName = serverLocation.getName();
            try {
                RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
                Repository repository = repositoryManager.getRepository(serverName);
                session = repository.open();
                log.debug((Object)("Opened session for repository " + serverName));
            }
            catch (Exception e) {
                throw new ClientException("Error opening session for repository " + serverName, (Throwable)e);
            }
            this.sessions.put(serverLocation, session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Destroy
    @PermitAll
    public void remove() {
        for (Map.Entry<RepositoryLocation, CoreSession> entry : this.sessions.entrySet()) {
            String serverName = entry.getKey().getName();
            CoreSession session = entry.getValue();
            try {
                Repository.close((CoreSession)session);
                log.debug((Object)("Closed session for repository " + serverName));
            }
            catch (EJBAccessException e) {
                log.debug((Object)("EJBAccessException while closing session for repository " + serverName));
                LoginContext lc = null;
                try {
                    lc = Framework.login();
                    Repository.close((CoreSession)session);
                }
                catch (LoginException le) {
                    log.error((Object)"Unable to login as System", (Throwable)le);
                }
                finally {
                    if (lc == null) continue;
                    try {
                        lc.logout();
                    }
                    catch (LoginException lo) {
                        log.error((Object)"Error when loggin out", (Throwable)lo);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Error closing session for repository " + serverName), (Throwable)e);
            }
        }
        this.sessions.clear();
    }
}

