/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.pagination;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.EmptyResultsProvider;
import org.nuxeo.ecm.platform.ui.web.api.ResultsProviderFarm;
import org.nuxeo.ecm.platform.ui.web.api.SortNotSupportedException;
import org.nuxeo.ecm.platform.ui.web.pagination.ResultsProviderFarmUserException;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.pagination.ResultsProviderService;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.runtime.api.Framework;

@Deprecated
@Name(value="resultsProvidersCache")
@Scope(value=ScopeType.CONVERSATION)
public class ResultsProvidersCacheBean
implements ResultsProvidersCache,
Serializable {
    private static final long serialVersionUID = 8632024396770685542L;
    private static final Log log = LogFactory.getLog(ResultsProvidersCacheBean.class);
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    private transient Map<String, PagedDocumentsProvider> resultsProvidersCache;
    @In(required=false)
    @Out(scope=ScopeType.EVENT, required=false)
    private transient Set<String> cleanProviders;

    @Override
    @Create
    public void init() {
        log.debug((Object)"Initializing...");
        this.initCache();
    }

    @Override
    public void destroy() {
        log.debug((Object)"Destroy...");
    }

    private void initCache() {
        if (this.resultsProvidersCache == null) {
            log.debug((Object)"Constructing a new, empty cache");
            this.resultsProvidersCache = new HashMap<String, PagedDocumentsProvider>();
        }
    }

    @Override
    public PagedDocumentsProvider get(String name) throws ClientException {
        try {
            return this.get(name, null);
        }
        catch (SortNotSupportedException e) {
            throw new ClientException("unexpected sortNotSupported", (Throwable)e);
        }
    }

    @Override
    public PagedDocumentsProvider get(String name, SortInfo sortInfo) throws ClientException, SortNotSupportedException {
        PhaseId lifeCycleId = FacesLifecycle.getPhaseId();
        PagedDocumentsProvider provider = this.resultsProvidersCache.get(name);
        if (this.cleanProviders == null) {
            this.cleanProviders = new HashSet<String>();
        }
        if (provider == null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("(Re)building provider '" + name + "'"));
                }
                provider = this.getProviderFarmFor(name).getResultsProvider(name, sortInfo);
            }
            catch (ResultsProviderFarmUserException e) {
                if (lifeCycleId != PhaseId.RENDER_RESPONSE) {
                    this.facesMessages.add(FacesMessage.SEVERITY_WARN, this.resourcesAccessor.getMessages().get(e.getMessage()), new Object[0]);
                }
                return this.getEmptyResultsProvider(name);
            }
            catch (Exception e) {
                log.error((Object)"failed to obtain sorted resultProvider", (Throwable)e);
                try {
                    log.debug((Object)"retrying search without sort parameters");
                    provider = this.getProviderFarmFor(name).getResultsProvider(name, null);
                }
                catch (Exception e2) {
                    if (lifeCycleId != PhaseId.RENDER_RESPONSE) {
                        this.facesMessages.add(FacesMessage.SEVERITY_WARN, this.resourcesAccessor.getMessages().get("feedback.search.invalid"), new Object[0]);
                    }
                    this.resultsProvidersCache.put(name, (PagedDocumentsProvider)new EmptyResultsProvider());
                    return this.resultsProvidersCache.get(name);
                }
            }
            this.resultsProvidersCache.put(name, provider);
        } else if (!(this.cleanProviders.contains(name) || lifeCycleId != PhaseId.RENDER_RESPONSE && lifeCycleId != PhaseId.INVOKE_APPLICATION)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Refreshing dirty provider %s (jsf phase='%s')", name, lifeCycleId));
            }
            provider.refresh();
        }
        this.cleanProviders.add(name);
        return provider;
    }

    protected PagedDocumentsProvider getEmptyResultsProvider(String name) throws ClientException {
        Method method;
        ResultsProviderFarm farm = this.getProviderFarmFor(name);
        try {
            method = farm.getClass().getMethod("getEmptyResultsProvider", String.class);
        }
        catch (SecurityException e) {
            return new EmptyResultsProvider();
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)(farm.getClass().getName() + " will have to " + "implement getEmptyResultsProvider() for Nuxeo 5.2"));
            return new EmptyResultsProvider();
        }
        try {
            return (PagedDocumentsProvider)method.invoke((Object)farm, name);
        }
        catch (Exception e) {
            return new EmptyResultsProvider();
        }
    }

    @Override
    public void invalidate(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invalidating provider '" + name + "'"));
        }
        this.resultsProvidersCache.remove(name);
    }

    @Observer(value={"documentChildrenChanged", "locationSelectionChanged"}, create=false, inject=false)
    @BypassInterceptors
    public void invalidateChildrenProvider() {
        this.invalidate("CURRENT_DOC_CHILDREN");
    }

    public DocumentModelList getCurrentPageOf(String name) throws ClientException {
        return this.get(name).getCurrentPage();
    }

    @Deprecated
    public String getRecordStatus() {
        log.error((Object)"getRecordStatus has been called");
        int numberOfPages = 10;
        String numberOfPagesStr = numberOfPages == -1 ? "unknown" : Integer.toString(numberOfPages);
        return " of " + numberOfPagesStr;
    }

    private ResultsProviderFarm getProviderFarmFor(String name) throws ClientException {
        ResultsProviderService service = (ResultsProviderService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.webapp.pagination.ResultsProviderService"));
        String farmName = service.getFarmNameFor(name);
        if (farmName == null) {
            throw new ClientException("Unknown results provider: " + name);
        }
        Object ob = Contexts.lookupInStatefulContexts((String)farmName);
        if (ob == null) {
            SeamComponentCallHelper.getSeamComponentByName((String)farmName);
            ob = Contexts.lookupInStatefulContexts((String)farmName);
            if (ob == null) {
                throw new ClientException(farmName + " provider farm is not a registered seam component");
            }
        }
        return (ResultsProviderFarm)ob;
    }

    @Override
    public int getNumberOfPages() {
        return 0;
    }

    @Override
    public int getPageIndex() {
        return 0;
    }
}

