/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.seam;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.webapp.seam.SeamHotReloadHelper;

@Name(value="seamReload")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class NuxeoSeamHotReloader
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    private static final Log log = LogFactory.getLog(NuxeoSeamHotReloader.class);

    @Factory(value="seamHotReloadIsEnabled", scope=ScopeType.APPLICATION)
    public boolean isHotReloadEnabled() {
        return SeamHotReloadHelper.isHotReloadEnabled();
    }

    public String doReload() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        String bigDownloadURL = BaseURL.getBaseURL((ServletRequest)request);
        bigDownloadURL = bigDownloadURL + "restAPI/seamReload";
        try {
            response.resetBuffer();
            response.sendRedirect(bigDownloadURL);
            response.flushBuffer();
            request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
            facesContext.responseComplete();
        }
        catch (Exception e) {
            log.error((Object)"Error during redirect", (Throwable)e);
        }
        return null;
    }
}

