/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.search;

import java.io.Serializable;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="documentSearchActions")
@Scope(value=ScopeType.CONVERSATION)
public class DocumentSearchActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String simpleSearchKeywords = "";
    protected String nxqlQuery = "";

    public String getSimpleSearchKeywords() {
        return this.simpleSearchKeywords;
    }

    public void setSimpleSearchKeywords(String simpleSearchKeywords) {
        this.simpleSearchKeywords = simpleSearchKeywords;
    }

    public void validateSimpleSearchKeywords(FacesContext context, UIComponent component, Object value) {
        String[] keywords;
        if (!(value instanceof String) || StringUtils.isEmpty((String)((String)value))) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"feedback.search.noKeywords"), null);
            throw new ValidatorException(message);
        }
        for (String keyword : keywords = ((String)value).split(" ")) {
            if (!keyword.startsWith("*")) continue;
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"feedback.search.star"), null);
            throw new ValidatorException(message);
        }
    }

    public String getNxqlQuery() {
        return this.nxqlQuery;
    }

    public void setNxqlQuery(String nxqlQuery) {
        this.nxqlQuery = nxqlQuery;
    }

    public Literal getNxqlQueryAsLiteral() {
        if (this.nxqlQuery == null) {
            return new StringLiteral("");
        }
        return new StringLiteral(this.nxqlQuery);
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false)
    @BypassInterceptors
    public void resetSearches() {
        this.simpleSearchKeywords = "";
        this.nxqlQuery = "";
    }
}

