/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ui.tree.document;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.webengine.ui.tree.ContentProvider;

public class DocumentContentProvider
implements ContentProvider {
    private static final long serialVersionUID = 1L;
    protected CoreSession session;

    public DocumentContentProvider(CoreSession session) {
        this.session = session;
    }

    public void setSession(CoreSession session) {
        this.session = session;
    }

    public CoreSession getSession() {
        return this.session;
    }

    @Override
    public Object[] getElements(Object input) {
        if (input instanceof Repository) {
            try {
                return new DocumentModel[]{this.session.getRootDocument()};
            }
            catch (ClientException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.getChildren(input);
    }

    @Override
    public Object[] getChildren(Object obj) {
        if (obj instanceof DocumentModel) {
            try {
                DocumentModelList list = this.session.getChildren(((DocumentModel)obj).getRef());
                return list.toArray((Object[])new DocumentModel[list.size()]);
            }
            catch (ClientException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public boolean isContainer(Object obj) {
        if (obj instanceof DocumentModel) {
            return ((DocumentModel)obj).isFolder();
        }
        return false;
    }

    @Override
    public String getLabel(Object obj) {
        if (obj instanceof DocumentModel) {
            try {
                return ((DocumentModel)obj).getTitle();
            }
            catch (ClientException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String[] getFacets(Object object) {
        return null;
    }

    @Override
    public String getName(Object obj) {
        if (obj instanceof DocumentModel) {
            return ((DocumentModel)obj).getName();
        }
        return null;
    }
}

