/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.service;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.pictures.tiles.service.PictureTilingComponent;
import org.nuxeo.ecm.platform.preview.adapter.AbstractPreviewer;
import org.nuxeo.ecm.platform.preview.adapter.ImagePreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class TiledImagePreviewer
extends AbstractPreviewer
implements MimeTypePreviewer {
    private static final Log log = LogFactory.getLog(TiledImagePreviewer.class);
    protected static final String ORIGINAL_JPEG_VIEW_NAME = "OriginalJpeg";
    protected static final String ORIGINAL_VIEW_NAME = "Original";

    public List<Blob> getPreview(Blob blob, DocumentModel dm) throws PreviewException {
        if (this.useTiling(blob, dm)) {
            ArrayList<Blob> blobResults = new ArrayList<Blob>();
            String htmlFile = this.getString().replace("$repoId$", dm.getRepositoryName());
            htmlFile = htmlFile.replace("$docId$", dm.getId());
            htmlFile = htmlFile.replace("$tileWidth$", "200");
            htmlFile = htmlFile.replace("$tileHeight$", "200");
            htmlFile = htmlFile.replace("$maxTiles$", "2");
            StringBlob mainBlob = new StringBlob(htmlFile);
            mainBlob.setFilename("index.html");
            mainBlob.setMimeType("text/html");
            blob.setFilename("image");
            blobResults.add((Blob)mainBlob);
            blobResults.add(blob);
            return blobResults;
        }
        return new ImagePreviewer().getPreview(blob, dm);
    }

    protected boolean useTiling(Blob blob, DocumentModel dm) {
        Long width = 0L;
        Long height = 0L;
        if ("Picture".equals(dm.getType())) {
            try {
                PictureResourceAdapter adapter = (PictureResourceAdapter)dm.getAdapter(PictureResourceAdapter.class);
                String xpath = adapter.getViewXPath(ORIGINAL_JPEG_VIEW_NAME);
                if (xpath == null && (xpath = adapter.getViewXPath(ORIGINAL_VIEW_NAME)) == null) {
                    xpath = adapter.getFirstViewXPath();
                }
                width = (Long)dm.getPropertyValue(xpath + "width");
                height = (Long)dm.getPropertyValue(xpath + "height");
            }
            catch (ClientException e) {
                log.error((Object)"Failed to get picture dimensions", (Throwable)e);
            }
        } else {
            ImagingService imagingService = (ImagingService)Framework.getLocalService(ImagingService.class);
            if (imagingService != null) {
                Map imageMetadata = imagingService.getImageMetadata(blob);
                width = ((Integer)imageMetadata.get("width")).longValue();
                height = ((Integer)imageMetadata.get("height")).longValue();
            }
        }
        Integer widthThreshold = Integer.valueOf(PictureTilingComponent.getEnvValue((String)"WidthThreshold", (String)"1200"));
        Integer heightThreshold = Integer.valueOf(PictureTilingComponent.getEnvValue((String)"HeightThreshold", (String)"1200"));
        return width > (long)widthThreshold.intValue() || height > (long)heightThreshold.intValue();
    }

    private String getString() {
        StringWriter writer = new StringWriter();
        writer.write("<html><head></head><body>");
        writer.write("<script type=\"text/javascript\">");
        writer.write("var serverSetting = {");
        writer.write("repoId : '$repoId$' ,");
        writer.write("docId : '$docId$' ,");
        writer.write("contextPath : '" + VirtualHostHelper.getContextPathProperty() + "'");
        writer.write("};");
        writer.write("</script>");
        writer.write("<script type=\"text/javascript\"");
        writer.write("src=\"" + VirtualHostHelper.getContextPathProperty() + "/org.nuxeo.ecm.platform.pictures.tiles.gwt.TilingPreview/org.nuxeo.ecm.platform.pictures.tiles.gwt.TilingPreview.nocache.js\">");
        writer.write("</script>");
        this.appendPreviewSettings(writer);
        writer.write("<div id=\"display\"></div>");
        writer.write("</body></html>");
        return writer.toString();
    }

    private void appendPreviewSettings(StringWriter sb) {
        sb.append("<script type=\"text/javascript\">");
        sb.append("var previewSettings = { ");
        sb.append("imageOnly: \"true\", ");
        sb.append("multiImageAnnotation: \"true\", ");
        sb.append("xPointerFilterPath: \"org_nuxeo_ecm_platform_pictures_tiles_gwt_client_XPointerFilter\", ");
        sb.append("pointerAdapter: \"org_nuxeo_ecm_platform_pictures_tiles_gwt_client_PointerAdapter\", ");
        sb.append("annotationDecoratorFunction: \"org_nuxeo_ecm_platform_pictures_tiles_gwt_client_Update_Annotated_Document\"");
        sb.append("}");
        sb.append("</script>");
    }
}

