/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.runtime.api.Framework;

public class PictureBookBlobHolder
extends DocumentBlobHolder {
    private CoreSession session;

    public PictureBookBlobHolder(DocumentModel doc, String xPath) {
        super(doc, xPath);
    }

    public Blob getBlob() throws ClientException {
        DocumentModel documentModel = (DocumentModel)this.getSession().getChildrenIterator(this.doc.getRef(), "Picture").next();
        PictureResourceAdapter picture = (PictureResourceAdapter)documentModel.getAdapter(PictureResourceAdapter.class);
        return picture.getPictureFromTitle("Original");
    }

    public List<Blob> getBlobs() throws ClientException {
        return this.getBlobs("Original");
    }

    public List<Blob> getBlobs(String title) throws ClientException {
        DocumentModelList docList = this.getSession().getChildren(this.doc.getRef(), "Picture");
        ArrayList<Blob> blobList = new ArrayList<Blob>(docList.size());
        for (DocumentModel documentModel : docList) {
            PictureResourceAdapter picture = (PictureResourceAdapter)documentModel.getAdapter(PictureResourceAdapter.class);
            blobList.add(picture.getPictureFromTitle(title));
        }
        return blobList;
    }

    public String getHash() throws ClientException {
        String h;
        Blob blob = this.getBlob();
        if (blob != null && (h = blob.getDigest()) != null) {
            return h;
        }
        return this.doc.getId() + this.xPath + this.getModificationDate().toString();
    }

    private CoreSession getSession() throws ClientException {
        if (this.session == null && this.doc != null && this.doc.getSessionId() != null) {
            this.session = CoreInstance.getInstance().getSession(this.doc.getSessionId());
        }
        if (this.session == null) {
            try {
                RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
                String repoName = null;
                if (this.doc != null) {
                    repoName = this.doc.getRepositoryName();
                }
                if (repoName != null) {
                    return rm.getRepository(repoName).open();
                }
                return rm.getDefaultRepository().open();
            }
            catch (Exception e) {
                throw new ClientException("Cannot get default repository ", (Throwable)e);
            }
        }
        return this.session;
    }
}

