/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.io.impl;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentTreeIterator;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentReaderFactory;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.DocumentWriterFactory;
import org.nuxeo.ecm.core.io.DocumentsExporter;
import org.nuxeo.ecm.core.io.DocumentsImporter;
import org.nuxeo.ecm.core.io.exceptions.ExportDocumentException;
import org.nuxeo.ecm.core.io.exceptions.ImportDocumentException;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;
import org.nuxeo.ecm.core.io.impl.IODocumentManagerImpl;
import org.nuxeo.ecm.platform.io.api.IOManager;
import org.nuxeo.ecm.platform.io.api.IOResourceAdapter;
import org.nuxeo.ecm.platform.io.api.IOResources;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamManager;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class IOManagerImpl
implements IOManager {
    private static final long serialVersionUID = 5789086884484295921L;
    private static final Log log = LogFactory.getLog(IOManagerImpl.class);
    protected final Map<String, IOResourceAdapter> adaptersRegistry = new HashMap<String, IOResourceAdapter>();

    private static CoreSession getCoreSession(String repo) throws ClientException {
        CoreSession systemSession;
        try {
            Framework.login();
            RepositoryManager manager = (RepositoryManager)Framework.getService(RepositoryManager.class);
            systemSession = manager.getRepository(repo).open();
        }
        catch (Exception e) {
            throw new ClientException("Failed to open core session to repository " + repo, (Throwable)e);
        }
        return systemSession;
    }

    private static void closeStream(Closeable stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
    }

    public IOResourceAdapter getAdapter(String name) throws ClientException {
        return this.adaptersRegistry.get(name);
    }

    public void addAdapter(String name, IOResourceAdapter adapter) throws ClientException {
        if ("documents".equals(name)) {
            log.error((Object)"Cannot register adapter with name documents");
            return;
        }
        this.adaptersRegistry.put(name, adapter);
    }

    public void removeAdapter(String name) throws ClientException {
        this.adaptersRegistry.remove(name);
    }

    public void exportDocumentsAndResources(OutputStream out, String repo, final String format, Collection<String> ioAdapters, final DocumentReader customDocReader) throws ExportDocumentException, IOException, ClientException {
        DocumentsExporter docsExporter = new DocumentsExporter(){

            public DocumentTranslationMap exportDocs(OutputStream out) throws ExportDocumentException, ClientException, IOException {
                IODocumentManagerImpl docManager = new IODocumentManagerImpl();
                DocumentTranslationMap map = docManager.exportDocuments(out, customDocReader, format);
                return map;
            }
        };
        this.exportDocumentsAndResources(out, repo, docsExporter, ioAdapters);
    }

    public void exportDocumentsAndResources(OutputStream out, final String repo, final Collection<DocumentRef> sources, final boolean recurse, final String format, Collection<String> ioAdapters) throws IOException, ClientException, ExportDocumentException {
        DocumentsExporter docsExporter = new DocumentsExporter(){

            public DocumentTranslationMap exportDocs(OutputStream out) throws ExportDocumentException, ClientException, IOException {
                IODocumentManagerImpl docManager = new IODocumentManagerImpl();
                DocumentTranslationMap map = docManager.exportDocuments(out, repo, sources, recurse, format);
                return map;
            }
        };
        this.exportDocumentsAndResources(out, repo, docsExporter, ioAdapters);
    }

    void exportDocumentsAndResources(OutputStream out, String repo, DocumentsExporter docsExporter, Collection<String> ioAdapters) throws IOException, ClientException, ExportDocumentException {
        ArrayList<String> doneAdapters = new ArrayList<String>();
        ZipOutputStream zip = new ZipOutputStream(out);
        zip.setMethod(8);
        zip.setLevel(9);
        ByteArrayOutputStream docsZip = new ByteArrayOutputStream();
        DocumentTranslationMap map = docsExporter.exportDocs((OutputStream)docsZip);
        ZipEntry docsEntry = new ZipEntry("documents.zip");
        zip.putNextEntry(docsEntry);
        zip.write(docsZip.toByteArray());
        zip.closeEntry();
        docsZip.close();
        doneAdapters.add("documents");
        Set allSources = map.getDocRefMap().keySet();
        if (ioAdapters != null && !ioAdapters.isEmpty()) {
            for (String adapterName : ioAdapters) {
                String filename = adapterName + ".xml";
                IOResourceAdapter adapter = this.getAdapter(adapterName);
                if (adapter == null) {
                    log.warn((Object)("Adapter " + adapterName + " not found"));
                    continue;
                }
                if (doneAdapters.contains(adapterName)) {
                    log.warn((Object)("Export for adapter " + adapterName + " already done"));
                    continue;
                }
                IOResources resources = adapter.extractResources(repo, allSources);
                resources = adapter.translateResources(repo, resources, map);
                ByteArrayOutputStream adapterOut = new ByteArrayOutputStream();
                adapter.getResourcesAsXML((OutputStream)adapterOut, resources);
                ZipEntry adapterEntry = new ZipEntry(filename);
                zip.putNextEntry(adapterEntry);
                zip.write(adapterOut.toByteArray());
                zip.closeEntry();
                doneAdapters.add(adapterName);
                adapterOut.close();
            }
        }
        try {
            zip.close();
        }
        catch (ZipException e) {
            // empty catch block
        }
    }

    public void importDocumentsAndResources(InputStream in, final String repo, final DocumentRef root) throws IOException, ClientException, ImportDocumentException {
        DocumentsImporter docsImporter = new DocumentsImporter(){

            public DocumentTranslationMap importDocs(InputStream sourceStream) throws ImportDocumentException, ClientException, IOException {
                IODocumentManagerImpl docManager = new IODocumentManagerImpl();
                return docManager.importDocuments(sourceStream, repo, root);
            }
        };
        this.importDocumentsAndResources(docsImporter, in, repo);
    }

    public void importDocumentsAndResources(InputStream in, String repo, DocumentRef root, final DocumentWriter customDocWriter) throws IOException, ClientException, ImportDocumentException {
        DocumentsImporter docsImporter = new DocumentsImporter(){

            public DocumentTranslationMap importDocs(InputStream sourceStream) throws ImportDocumentException, ClientException, IOException {
                IODocumentManagerImpl docManager = new IODocumentManagerImpl();
                return docManager.importDocuments(sourceStream, customDocWriter);
            }
        };
        this.importDocumentsAndResources(docsImporter, in, repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importDocumentsAndResources(DocumentsImporter docsImporter, InputStream in, String repo) throws IOException, ClientException, ImportDocumentException {
        ZipInputStream zip = new ZipInputStream(in);
        ZipEntry zentry = zip.getNextEntry();
        String docZipFilename = "documents.zip";
        if (zentry == null || !docZipFilename.equals(zentry.getName())) {
            zip.close();
            throw new ImportDocumentException("Invalid archive");
        }
        File temp = File.createTempFile("nuxeo-import-adapters-", ".zip");
        FileOutputStream outDocs = new FileOutputStream(temp);
        try {
            FileUtils.copy((InputStream)zip, (OutputStream)outDocs);
        }
        finally {
            outDocs.close();
        }
        zip.closeEntry();
        FileInputStream tempIn = new FileInputStream(temp.getPath());
        DocumentTranslationMap map = docsImporter.importDocs((InputStream)tempIn);
        ((InputStream)tempIn).close();
        temp.delete();
        while ((zentry = zip.getNextEntry()) != null) {
            String entryName = zentry.getName();
            if (entryName.endsWith(".xml")) {
                String ioAdapterName = entryName.substring(0, entryName.length() - 4);
                IOResourceAdapter adapter = this.getAdapter(ioAdapterName);
                if (adapter == null) {
                    log.warn((Object)("Adapter " + ioAdapterName + " not available. Unable to import associated resources."));
                    continue;
                }
                IOResources resources = adapter.loadResourcesFromXML((InputStream)zip);
                IOResources newResources = adapter.translateResources(repo, resources, map);
                log.info((Object)("store resources with adapter " + ioAdapterName));
                adapter.storeResources(newResources);
            } else {
                log.warn((Object)("skip entry: " + entryName));
            }
            try {
                zip.closeEntry();
            }
            catch (Exception e) {
                log.error((Object)("Please check code handling entry " + entryName), (Throwable)e);
            }
        }
        zip.close();
    }

    public Collection<DocumentRef> copyDocumentsAndResources(String repo, Collection<DocumentRef> sources, DocumentLocation targetLocation, Collection<String> ioAdapters) throws ClientException {
        if (sources == null || sources.isEmpty()) {
            return null;
        }
        String newRepo = targetLocation.getServerName();
        if (!repo.equals(newRepo)) {
            throw new ClientException("Cannot copy to different server");
        }
        ArrayList<DocumentRef> roots = new ArrayList<DocumentRef>();
        CoreSession coreSession = IOManagerImpl.getCoreSession(repo);
        for (DocumentRef source : sources) {
            DocumentTranslationMapImpl map = new DocumentTranslationMapImpl(repo, repo);
            DocumentModel sourceDoc = coreSession.getDocument(source);
            DocumentModel destDoc = coreSession.copy(source, targetLocation.getDocRef(), null);
            roots.add(destDoc.getRef());
            DocumentTreeIterator sourceIt = new DocumentTreeIterator(coreSession, sourceDoc);
            DocumentTreeIterator destIt = new DocumentTreeIterator(coreSession, destDoc);
            while (sourceIt.hasNext()) {
                DocumentModel sourceItem = sourceIt.next();
                DocumentRef sourceRef = sourceItem.getRef();
                if (!destIt.hasNext()) {
                    map.put(sourceRef, null);
                    continue;
                }
                DocumentModel destItem = destIt.next();
                DocumentRef destRef = destItem.getRef();
                map.put(sourceRef, destRef);
            }
            Set allSources = map.getDocRefMap().keySet();
            if (ioAdapters == null || ioAdapters.isEmpty()) continue;
            for (String adapterName : ioAdapters) {
                IOResourceAdapter adapter = this.getAdapter(adapterName);
                if (adapter == null) {
                    log.warn((Object)("Adapter " + adapterName + " not found"));
                    continue;
                }
                IOResources resources = adapter.extractResources(repo, allSources);
                IOResources newResources = adapter.translateResources(repo, resources, (DocumentTranslationMap)map);
                adapter.storeResources(newResources);
            }
        }
        coreSession.save();
        return roots;
    }

    public void copyDocumentsAndResources(String repo, Collection<DocumentRef> sources, String serverAddress, int jndiPort, DocumentLocation targetLocation, Collection<String> ioAdapters) throws ClientException {
        String docReaderFactoryName = null;
        String docWriterFactoryName = null;
        Map<String, Object> readerFactoryParams = null;
        Map<String, Object> writerFactoryParams = null;
        this.copyDocumentsAndResources(repo, sources, serverAddress, jndiPort, targetLocation, docReaderFactoryName, readerFactoryParams, docWriterFactoryName, writerFactoryParams, ioAdapters);
    }

    public void copyDocumentsAndResources(String repo, Collection<DocumentRef> sources, IOManager remoteIOManager, DocumentLocation targetLocation, Collection<String> ioAdapters) throws ClientException {
        String docReaderFactoryName = null;
        String docWriterFactoryName = null;
        Map<String, Object> readerFactoryParams = null;
        Map<String, Object> writerFactoryParams = null;
        this.copyDocumentsAndResources(repo, sources, remoteIOManager, targetLocation, docReaderFactoryName, readerFactoryParams, docWriterFactoryName, writerFactoryParams, ioAdapters);
    }

    public void importExportedFile(String uri, DocumentLocation targetLocation) throws ClientException {
        File tempFile = IOManagerImpl.getLocalFile(uri);
        FileInputStream in = null;
        try {
            in = new FileInputStream(tempFile);
            this.importDocumentsAndResources(in, targetLocation.getServerName(), targetLocation.getDocRef());
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        finally {
            tempFile.delete();
            try {
                IOManagerImpl.closeStream(in);
            }
            catch (IOException e) {
                throw new ClientException((Throwable)e);
            }
        }
    }

    public void copyDocumentsAndResources(String repo, Collection<DocumentRef> sources, String serverAddress, int jndiPort, DocumentLocation targetLocation, String docReaderFactoryName, Map<String, Object> readerFactoryParams, String docWriterFactoryName, Map<String, Object> writerFactoryParams, Collection<String> ioAdapters) throws ClientException {
        IOManager remoteIOManager;
        String serviceUri = "jboss://" + serverAddress + ":" + jndiPort + "/nuxeo/IOManagerBean/remote";
        log.info((Object)("Connect to IOManager at: " + serviceUri));
        try {
            remoteIOManager = (IOManager)ServiceManager.getInstance().getService(serviceUri);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        this.copyDocumentsAndResources(repo, sources, remoteIOManager, targetLocation, docReaderFactoryName, readerFactoryParams, docWriterFactoryName, writerFactoryParams, ioAdapters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyDocumentsAndResources(String repo, Collection<DocumentRef> sources, IOManager remoteIOManager, DocumentLocation targetLocation, String docReaderFactoryName, Map<String, Object> readerFactoryParams, String docWriterFactoryName, Map<String, Object> writerFactoryParams, Collection<String> ioAdapters) throws ClientException {
        String uri = null;
        try {
            uri = this.externalizeExport(repo, sources, docReaderFactoryName, readerFactoryParams, ioAdapters);
            if (docWriterFactoryName == null) {
                remoteIOManager.importExportedFile(uri, targetLocation);
            } else {
                remoteIOManager.importExportedFile(uri, targetLocation, docWriterFactoryName, writerFactoryParams);
            }
            if (uri == null) return;
        }
        catch (Throwable throwable) {
            if (uri == null) throw throwable;
            this.disposeExport(uri);
            throw throwable;
        }
        this.disposeExport(uri);
    }

    public String externalizeExport(String repo, Collection<DocumentRef> sources, Collection<String> ioAdapters) throws ClientException {
        return this.externalizeExport(repo, sources, null, null, ioAdapters);
    }

    public String externalizeExport(String repo, String docReaderFactoryName, Map<String, Object> readerFactoryParams, Collection<String> ioAdapters) throws ClientException {
        return this.externalizeExport(repo, null, docReaderFactoryName, readerFactoryParams, ioAdapters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String externalizeExport(String repo, Collection<DocumentRef> sources, String docReaderFactoryName, Map<String, Object> readerFactoryParams, Collection<String> ioAdapters) throws ClientException {
        String string;
        File tempFile = null;
        FileOutputStream fos = null;
        FileSource src = null;
        try {
            tempFile = File.createTempFile("export-import", ".zip");
            fos = new FileOutputStream(tempFile);
            String format = null;
            if (docReaderFactoryName == null) {
                this.exportDocumentsAndResources(fos, repo, sources, true, format, ioAdapters);
            } else {
                Class<?> clazz = Class.forName(docReaderFactoryName);
                Object factoryObj = clazz.newInstance();
                if (!(factoryObj instanceof DocumentReaderFactory)) {
                    throw new ClientException("bad class type: " + factoryObj);
                }
                DocumentReader customDocReader = ((DocumentReaderFactory)factoryObj).createDocReader(readerFactoryParams);
                this.exportDocumentsAndResources(fos, repo, format, ioAdapters, customDocReader);
            }
            StreamManager localStreamManager = (StreamManager)Framework.getLocalService(StreamManager.class);
            if (localStreamManager == null) {
                throw new ClientException("StreamManager service not available locally");
            }
            src = new FileSource(tempFile);
            double start = System.currentTimeMillis();
            String uri = null;
            try {
                uri = localStreamManager.addStream((StreamSource)src);
                double end = System.currentTimeMillis();
                log.info((Object)(">>> upload took " + (end - start) / 1000.0 + " sec."));
            }
            catch (IOException e) {
                throw new ClientException((Throwable)e);
            }
            string = uri;
        }
        catch (Exception e) {
            try {
                throw new ClientException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    IOManagerImpl.closeStream(fos);
                }
                catch (IOException e2) {
                    throw new ClientException((Throwable)e2);
                }
                if (src != null) {
                    src.destroy();
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
                throw throwable;
            }
        }
        try {
            IOManagerImpl.closeStream(fos);
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        if (src != null) {
            src.destroy();
        }
        if (tempFile != null) {
            tempFile.delete();
        }
        return string;
    }

    public void disposeExport(String uri) throws ClientException {
        StreamManager localStreamManager = (StreamManager)Framework.getLocalService(StreamManager.class);
        if (localStreamManager == null) {
            throw new ClientException("StreamManager service not available locally");
        }
        localStreamManager.removeStream(uri);
    }

    public void importExportedFile(String uri, DocumentLocation targetLocation, String docWriterFactoryName, Map<String, Object> factoryParams) throws ClientException {
        DocumentWriter customDocWriter = IOManagerImpl.createDocWriter(docWriterFactoryName, factoryParams);
        File tempFile = IOManagerImpl.getLocalFile(uri);
        FileInputStream in = null;
        try {
            in = new FileInputStream(tempFile);
            this.importDocumentsAndResources(in, targetLocation.getServerName(), targetLocation.getDocRef(), customDocWriter);
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        finally {
            customDocWriter.close();
            try {
                IOManagerImpl.closeStream(in);
            }
            catch (IOException e) {
                throw new ClientException((Throwable)e);
            }
            tempFile.delete();
        }
    }

    private static File getLocalFile(String uri) throws ClientException {
        File tempFile;
        StreamManager streamManager = (StreamManager)Framework.getLocalService(StreamManager.class);
        double start = System.currentTimeMillis();
        try {
            tempFile = File.createTempFile("export-import", ".zip");
            log.info((Object)("get stream source at uri: " + uri));
            StreamSource source = streamManager.getStream(uri);
            if (source == null) {
                throw new ClientException("cannot get StreamSource at uri: " + uri);
            }
            source.copyTo(tempFile);
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        double end = System.currentTimeMillis();
        log.info((Object)(">>> download took " + (end - start) / 1000.0 + " sec."));
        return tempFile;
    }

    private static DocumentWriter createDocWriter(String docWriterFactoryName, Map<String, Object> factoryParams) throws ClientException {
        Object factoryObj;
        try {
            Class<?> clazz = Class.forName(docWriterFactoryName);
            factoryObj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new ClientException("cannot instantiate factory " + docWriterFactoryName, (Throwable)e);
        }
        if (!(factoryObj instanceof DocumentWriterFactory)) {
            throw new ClientException("bad class type: " + factoryObj);
        }
        DocumentWriter customDocWriter = ((DocumentWriterFactory)factoryObj).createDocWriter(factoryParams);
        if (customDocWriter == null) {
            throw new ClientException("null DocumentWriter created by " + docWriterFactoryName);
        }
        return customDocWriter;
    }

    private static DocumentReader createDocReader(String docReaderFactoryName, Map<String, Object> factoryParams) throws ClientException {
        Object factoryObj;
        try {
            Class<?> clazz = Class.forName(docReaderFactoryName);
            factoryObj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new ClientException("cannot instantiate factory " + docReaderFactoryName, (Throwable)e);
        }
        if (!(factoryObj instanceof DocumentReaderFactory)) {
            throw new ClientException("bad class type: " + factoryObj);
        }
        DocumentReader customDocReader = ((DocumentReaderFactory)factoryObj).createDocReader(factoryParams);
        if (customDocReader == null) {
            throw new ClientException("null DocumentReader created by " + docReaderFactoryName);
        }
        return customDocReader;
    }

    public void importFromStreamSource(String uri, DocumentLocation targetLocation, String docReaderFactoryClassName, Map<String, Object> rFactoryParams, String docWriterFactoryClassName, Map<String, Object> wFactoryParams) throws ClientException {
        log.info((Object)("import source uri: " + uri));
        DocumentWriter customDocWriter = IOManagerImpl.createDocWriter(docWriterFactoryClassName, wFactoryParams);
        DocumentReader customDocReader = null;
        File tempFile = IOManagerImpl.getLocalFile(uri);
        FileInputStream in = null;
        try {
            in = new FileInputStream(tempFile);
            if (rFactoryParams == null) {
                rFactoryParams = new HashMap<String, Object>();
            }
            rFactoryParams.put("source_stream", in);
            customDocReader = IOManagerImpl.createDocReader(docReaderFactoryClassName, rFactoryParams);
            IODocumentManagerImpl docManager = new IODocumentManagerImpl();
            DocumentTranslationMap map = docManager.importDocuments(customDocReader, customDocWriter);
        }
        catch (IOException e) {
            String msg = "Cannot import from uri: " + uri;
            throw new ClientException(msg, (Throwable)e);
        }
        finally {
            if (customDocReader != null) {
                customDocReader.close();
            }
            customDocWriter.close();
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            tempFile.delete();
            this.disposeExport(uri);
        }
    }
}

