/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.jsf;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.connect.client.jsf.SubscriptionStatusWrapper;
import org.nuxeo.connect.connector.CanNotReachConnectServer;
import org.nuxeo.connect.connector.ConnectClientVersionMismatchError;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.data.SubscriptionStatus;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.runtime.api.Framework;

@Name(value="connectStatus")
@Scope(value=ScopeType.CONVERSATION)
public class ConnectStatusActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConnectStatusActionBean.class);
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    protected String login;
    protected String password;
    protected String registredProject;
    protected String instanceType;
    protected String instanceDescription;
    protected SubscriptionStatus instanceStatus;
    protected boolean loginValidated = false;
    protected boolean canNotReachConnectServer = false;
    protected String CLID;

    public String getRegistredCLID() throws Exception {
        if (this.isRegistred()) {
            return LogicalInstanceIdentifier.instance().getCLID();
        }
        return null;
    }

    public String getCLID() {
        return this.CLID;
    }

    public void setCLID(String cLID) {
        this.CLID = cLID;
    }

    public List<SelectItem> getInstanceTypes() {
        ArrayList<SelectItem> types = new ArrayList<SelectItem>();
        for (NuxeoClientInstanceType itype : NuxeoClientInstanceType.values()) {
            SelectItem item = new SelectItem((Object)itype.getValue(), "label.instancetype." + itype.getValue());
            types.add(item);
        }
        return types;
    }

    @Factory(scope=ScopeType.EVENT, value="connectLoginValidated")
    public boolean isLoginValidated() {
        return this.loginValidated;
    }

    protected ConnectRegistrationService getService() {
        return (ConnectRegistrationService)Framework.getLocalService(ConnectRegistrationService.class);
    }

    public String getRegistredProject() {
        return this.registredProject;
    }

    public void setRegistredProject(String registredProject) {
        this.registredProject = registredProject;
    }

    public String getConnectLogin() {
        return this.login;
    }

    public void setConnectLogin(String login) {
        this.login = login;
    }

    public String getConnectPassword() {
        return this.password;
    }

    public void setConnectPassword(String password) {
        this.password = password;
    }

    @Factory(scope=ScopeType.EVENT, value="registredConnectInstance")
    public boolean isRegistred() {
        return this.getService().isInstanceRegistred();
    }

    protected void flushEventCache() {
        Contexts.getEventContext().remove("connectLoginValidated");
        Contexts.getEventContext().remove("projectsForRegistration");
        Contexts.getEventContext().remove("registredConnectInstance");
    }

    public void validateLogin() {
        if (this.login == null || this.password == null) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, "label.empty.loginpassword", new Object[0]);
            this.loginValidated = false;
            this.flushEventCache();
            return;
        }
        List<ConnectProject> prjs = this.getProjectsAvailableForRegistration();
        if (prjs == null || prjs.size() == 0) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, "label.bad.loginpassword.or.noproject", new Object[0]);
            this.loginValidated = false;
            this.flushEventCache();
            return;
        }
        this.flushEventCache();
        this.loginValidated = true;
    }

    @Factory(value="connectServerReachable", scope=ScopeType.EVENT)
    public boolean isConnectServerReachable() {
        return !this.canNotReachConnectServer;
    }

    public SubscriptionStatusWrapper getStatus() {
        if (this.instanceStatus == null && this.isRegistred()) {
            try {
                this.instanceStatus = this.getService().getConnector().getConnectStatus();
                this.instanceType = this.instanceStatus.getInstanceType().toString();
                this.instanceDescription = this.instanceStatus.getDescription();
            }
            catch (CanNotReachConnectServer e) {
                this.canNotReachConnectServer = true;
                log.warn((Object)"can not reach connect server", (Throwable)e);
                return new SubscriptionStatusWrapper("Nuxeo Connect Server is not reachable");
            }
            catch (ConnectClientVersionMismatchError e) {
                log.warn((Object)"Connect Client does not have the required version to communicate with Nuxeo Connect Server", (Throwable)e);
                return new SubscriptionStatusWrapper(e.getMessage());
            }
            catch (ConnectServerError e) {
                log.error((Object)"Error while calling connect server", (Throwable)e);
                return new SubscriptionStatusWrapper(e.getMessage());
            }
        }
        if (this.instanceStatus != null) {
            return new SubscriptionStatusWrapper(this.instanceStatus);
        }
        return null;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceDescription() {
        return this.instanceDescription;
    }

    public void setInstanceDescription(String instanceDescription) {
        this.instanceDescription = instanceDescription;
    }

    public String enterConnectCredentials() {
        if (this.login == null) {
            return "connectCredential";
        }
        return "projectListing";
    }

    @Factory(scope=ScopeType.EVENT, value="projectsForRegistration")
    public List<ConnectProject> getProjectsAvailableForRegistration() {
        if (this.login == null) {
            return new ArrayList<ConnectProject>();
        }
        try {
            return this.getService().getAvailableProjectsForRegistration(this.login, this.password);
        }
        catch (Exception e) {
            log.error((Object)"Error while getting remote project", (Throwable)e);
            return new ArrayList<ConnectProject>();
        }
    }

    public String register() {
        if (this.registredProject == null) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, "label.empty.project", new Object[0]);
            return null;
        }
        try {
            this.getService().remoteRegisterInstance(this.login, this.password, this.registredProject, NuxeoClientInstanceType.fromString((String)this.instanceType), this.instanceDescription);
        }
        catch (Exception e) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, "label.connect.registrationError", new Object[0]);
            log.error((Object)"Error while registring instance", (Throwable)e);
        }
        this.flushEventCache();
        return null;
    }

    public String getCTID() throws Exception {
        return TechnicalInstanceIdentifier.instance().getCTID();
    }

    public String localRegister() {
        try {
            this.getService().localRegisterInstance(this.CLID, this.instanceDescription);
        }
        catch (LogicalInstanceIdentifier.InvalidCLID e) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, "label.connect.wrongCLID", new Object[0]);
        }
        catch (IOException e) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, "label.connect.registrationError", new Object[0]);
            log.error((Object)"Error while registring instance locally", (Throwable)e);
        }
        this.flushEventCache();
        return null;
    }
}

