/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.we;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.nuxeo.connect.client.we.RequestHelper;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="downloadHandler")
public class DownloadHandler
extends DefaultObject {
    @GET
    @Produces(value={"text/plain"})
    @Path(value="progress/{pkgId}")
    public String getDownloadProgress(@PathParam(value="pkgId") String pkgId) {
        DownloadingPackage pkg = this.getDownloadingPackage(pkgId);
        if (pkg == null) {
            return null;
        }
        return pkg.getDownloadProgress() + "";
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="progressPage/{pkgId}")
    public Object getDownloadProgressPage(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source) {
        PackageManager pm;
        DownloadingPackage pkg = this.getDownloadingPackage(pkgId);
        boolean downloadOver = false;
        if (pkg == null && (pkg = (pm = (PackageManager)Framework.getLocalService(PackageManager.class)).getPackage(pkgId)).getState() != 1) {
            downloadOver = true;
        }
        return this.getView("downloadStarted").arg("pkg", (Object)pkg).arg("source", (Object)source).arg("over", (Object)downloadOver);
    }

    protected DownloadingPackage getDownloadingPackage(String pkgId) {
        ConnectDownloadManager cdm = (ConnectDownloadManager)Framework.getLocalService(ConnectDownloadManager.class);
        List pkgs = cdm.listDownloadingPackages();
        for (DownloadingPackage pkg : pkgs) {
            if (!pkg.getId().equals(pkgId)) continue;
            return pkg;
        }
        return null;
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="start/{pkgId}")
    public Object startDownload(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        if (!RequestHelper.isInternalLink(this.getContext())) {
            DownloadablePackage pkg = pm.getPackage(pkgId);
            return this.getView("confirmDownload").arg("pkg", (Object)pkg).arg("source", (Object)source);
        }
        try {
            pm.download(pkgId);
        }
        catch (Exception e) {
            return this.getView("downloadError").arg("e", (Object)e);
        }
        return this.getView("downloadStarted").arg("pkg", (Object)this.getDownloadingPackage(pkgId)).arg("source", (Object)source).arg("over", (Object)false);
    }
}

