/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;

@Name(value="adminViews")
@Scope(value=ScopeType.CONVERSATION)
public class AdminViewManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Action currentView;
    protected Map<String, Action> currentSubViews = new HashMap<String, Action>();
    protected String externalPackageDownloadRequest;
    public static final String ADMIN_ACTION_CATEGORY = "NUXEO_ADMIN";
    @In(create=true, required=false)
    protected WebActions webActions;

    public String exit() throws ClientException {
        NavigationContext navigationContext = (NavigationContext)Contexts.getConversationContext().get("navigationContext");
        DocumentModel doc = navigationContext.getCurrentDocument();
        if (doc != null) {
            return navigationContext.navigateToDocument(doc);
        }
        return navigationContext.goHome();
    }

    @Factory(value="currentAdminView", scope=ScopeType.EVENT)
    public Action getCurrentView() {
        if (this.currentView == null) {
            this.currentView = this.getAvailableActions().get(0);
        }
        return this.currentView;
    }

    public void setCurrentView(Action currentView) {
        this.currentView = currentView;
    }

    public String getCurrentViewId() {
        return this.getCurrentView().getId();
    }

    public void setCurrentViewId(String currentViewId) {
        for (Action action : this.getAvailableActions()) {
            if (!action.getId().equals(currentViewId)) continue;
            this.currentView = action;
            return;
        }
    }

    @Factory(value="currentAdminSubView", scope=ScopeType.EVENT)
    public Action getCurrentSubView() {
        if (this.currentSubViews.get(this.getCurrentViewId()) == null) {
            this.currentSubViews.put(this.getCurrentViewId(), this.getAvailableSubActions().get(0));
        }
        return this.currentSubViews.get(this.getCurrentViewId());
    }

    public void setCurrentSubView(Action currentSubView) {
        this.currentSubViews.put(this.getCurrentViewId(), currentSubView);
    }

    @Factory(value="currentAdminSubViewId", scope=ScopeType.EVENT)
    public String getCurrentSubViewId() {
        return this.getCurrentSubView().getId();
    }

    public void setCurrentSubViewId(String currentSubViewId) {
        for (Action action : this.getAvailableSubActions()) {
            if (!action.getId().equals(currentSubViewId)) continue;
            this.setCurrentSubView(action);
            return;
        }
    }

    public List<Action> getAvailableActions() {
        return this.webActions.getActionsList(ADMIN_ACTION_CATEGORY);
    }

    public List<Action> getAvailableSubActions() {
        return this.webActions.getActionsList("NUXEO_ADMIN_" + this.getCurrentViewId());
    }

    public boolean hasExternalPackageDownloadRequest() {
        return this.externalPackageDownloadRequest != null;
    }

    public void addExternalPackageDownloadRequest(String pkgId) {
        this.externalPackageDownloadRequest = pkgId;
    }

    public String getExternalPackageDownloadRequest() {
        String id = this.externalPackageDownloadRequest;
        this.externalPackageDownloadRequest = null;
        return id;
    }
}

