/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.repo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.common.utils.Path;

public class RepoStatInfo {
    private final Map<String, Long> docsPerTypes = new ConcurrentHashMap<String, Long>();
    private long totalBlobSize = 0L;
    private long totalBlobNb = 0L;
    private long lastTotalNbDocs = 0L;
    private long lastTotalBlobSize = 0L;
    private long lastTotalBlobNb = 0L;
    private long maxDepth = 0L;
    private long maxChildren;
    private long maxBlobSize;
    private long versions = 0L;
    private long t1 = System.currentTimeMillis();
    protected float speed;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nNumber of documents    :");
        sb.append(this.getTotalNbDocs());
        for (String dtype : this.docsPerTypes.keySet()) {
            sb.append("\n   ");
            sb.append(dtype);
            sb.append(" :");
            sb.append(this.docsPerTypes.get(dtype));
        }
        sb.append("\nNumber of Blobs        :");
        sb.append(this.totalBlobNb);
        sb.append("\nSize of Blobs          :");
        sb.append(this.totalBlobSize);
        sb.append("\n");
        sb.append("\nMax tree depth         :");
        sb.append(this.maxDepth);
        sb.append("\nBiggest Folder         :");
        sb.append(this.maxChildren);
        sb.append(" children");
        sb.append("\nBiggest Blob           :");
        sb.append(this.maxBlobSize);
        return sb.toString();
    }

    public Long getDocTypeCount(String dType) {
        return this.docsPerTypes.get(dType);
    }

    public List<String> getDocTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(this.docsPerTypes.keySet());
        Collections.sort(types);
        return types;
    }

    public long getVersions() {
        return this.versions;
    }

    public long getMaxDepth() {
        return this.maxDepth;
    }

    public long getMaxChildren() {
        return this.maxChildren;
    }

    public long getMaxBlobSize() {
        return this.maxBlobSize;
    }

    public Map<String, Long> getDocsPerType() {
        return this.docsPerTypes;
    }

    public float getSpeed() {
        return this.speed;
    }

    public synchronized void addDoc(String type, Path path) {
        this.addDoc(type, path, false);
    }

    public synchronized void addDoc(String type, Path path, boolean isVersion) {
        Long counter = this.docsPerTypes.get(type);
        if ((long)path.segmentCount() > this.maxDepth) {
            this.maxDepth = path.segmentCount();
        }
        counter = counter == null ? Long.valueOf(1L) : Long.valueOf(counter + 1L);
        this.docsPerTypes.put(type, counter);
        if (isVersion) {
            ++this.versions;
        }
        this.speed = 1000L * this.getTotalNbDocs() / (System.currentTimeMillis() - this.t1);
    }

    public synchronized void addBlob(long size, Path path) {
        this.totalBlobSize += size;
        ++this.totalBlobNb;
        if (size > this.maxBlobSize) {
            this.maxBlobSize = size;
        }
    }

    public synchronized void childrenCount(long children, Path path) {
        if (children > this.maxChildren) {
            this.maxChildren = children;
        }
    }

    public long getTotalNbDocs() {
        long total = 0L;
        for (String k : this.docsPerTypes.keySet()) {
            total += this.docsPerTypes.get(k).longValue();
        }
        this.lastTotalNbDocs = total;
        return total;
    }

    public long getTotalBlobSize() {
        this.lastTotalBlobSize = this.totalBlobSize;
        return this.totalBlobSize;
    }

    public long getTotalBlobNumber() {
        this.lastTotalBlobNb = this.totalBlobNb;
        return this.totalBlobNb;
    }

    public long getLastTotalNbDocs() {
        return this.lastTotalNbDocs;
    }

    public long getLastTotalBlobSize() {
        return this.lastTotalBlobSize;
    }

    public long getLastTotalBlobNumber() {
        return this.lastTotalBlobNb;
    }
}

