/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.repo;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.admin.repo.StatsTask;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;

public class StatsTaskRunner
extends UnrestrictedSessionRunner {
    protected static final Log log = LogFactory.getLog(StatsTaskRunner.class);
    protected boolean includeBlob;
    protected DocumentRef rootref;
    protected StatsTask hostTask;

    public StatsTaskRunner(String repositoryName, boolean includeBlob, DocumentRef rootref, StatsTask hostTask) {
        super(repositoryName);
        this.includeBlob = includeBlob;
        this.rootref = rootref;
        this.hostTask = hostTask;
    }

    private void recurse(DocumentModel doc) throws ClientException {
        this.fetchInfoFromDoc(this.session, doc);
        if (doc.isFolder()) {
            long children = 0L;
            for (DocumentModel child : this.session.getChildren(doc.getRef())) {
                ++children;
                if (child.isFolder()) {
                    StatsTask newTask = this.hostTask.getNextTask(child);
                    if (newTask != null) {
                        this.hostTask.exec(newTask);
                        continue;
                    }
                    this.recurse(child);
                    continue;
                }
                this.fetchInfoFromDoc(this.session, child);
            }
            this.hostTask.getInfo().childrenCount(children, doc.getPath());
        }
    }

    private void fetchInfoFromDoc(CoreSession session, DocumentModel doc) throws ClientException {
        List blobs;
        BlobHolder bh;
        if (this.includeBlob && (bh = (BlobHolder)doc.getAdapter(BlobHolder.class)) != null && (blobs = bh.getBlobs()) != null) {
            for (Blob blob : blobs) {
                this.hostTask.getInfo().addBlob(blob.getLength(), doc.getPath());
            }
        }
        if (doc.isVersion()) {
            this.hostTask.getInfo().addDoc(doc.getType(), doc.getPath(), true);
        } else {
            this.hostTask.getInfo().addDoc(doc.getType(), doc.getPath());
            List versions = session.getVersions(doc.getRef());
            for (DocumentModel version : versions) {
                this.fetchInfoFromDoc(session, version);
            }
        }
    }

    public void run() throws ClientException {
        try {
            DocumentModel root = this.session.getDocument(this.rootref);
            this.recurse(root);
        }
        catch (Exception e) {
            log.error((Object)"Error while running StatsTaskRunner", (Throwable)e);
            throw new ClientException((Throwable)e);
        }
    }
}

