/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.seam;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.preview.helper.PreviewHelper;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;

@Name(value="previewActions")
@Scope(value=ScopeType.CONVERSATION)
public class PreviewActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected WebActions webActions;
    @RequestParameter
    private String fieldXPath;
    @RequestParameter
    private String previewTabId;
    private String fieldXPathValue;

    public boolean getHasPreview() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.documentHasPreview(currentDocument);
    }

    public boolean documentHasPreview(DocumentModel document) {
        if (document == null) {
            return false;
        }
        return PreviewHelper.typeSupportsPreview(document);
    }

    public String getPreviewURL() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return null;
        }
        return this.getPreviewURL(currentDocument);
    }

    public String getPreviewURL(DocumentModel doc) {
        return PreviewHelper.getPreviewURL(doc, this.fieldXPathValue);
    }

    public String getPreviewWithBlobPostProcessingURL() {
        String url = this.getPreviewURL();
        url = url + "?blobPostProcessing=true";
        return url;
    }

    public String getPreviewWithBlobPostProcessingURL(DocumentModel doc) {
        String url = this.getPreviewURL(doc);
        url = url + "?blobPostProcessing=true";
        return url;
    }

    @Observer(value={"documentSelectionChanged", "documentChanged"}, create=false, inject=false)
    public void resetFields() {
        this.fieldXPathValue = null;
    }

    public String doSetFieldXPath() throws ClientException {
        if (this.fieldXPath != null) {
            this.fieldXPathValue = this.fieldXPath.replace("/", "-");
        }
        return this.webActions.setCurrentTabAndNavigate(this.previewTabId);
    }
}

