/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.ejb;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.ejb.CommentManagerLocal;
import org.nuxeo.ecm.platform.comment.service.CommentService;
import org.nuxeo.ecm.platform.comment.service.CommentServiceHelper;

@Stateless
@Remote(value={CommentManager.class})
@Local(value={CommentManagerLocal.class})
public class CommentManagerBean
implements CommentManager {
    @Resource
    EJBContext context;
    private CommentManager commentManager;

    @PostConstruct
    public void initialize() {
        CommentService commentService = CommentServiceHelper.getCommentService();
        this.commentManager = commentService.getCommentManager();
    }

    public void cleanup() {
    }

    public void remove() {
    }

    public DocumentModel createComment(DocumentModel docModel, String comment) throws ClientException {
        try {
            String author = this.context.getCallerPrincipal().getName();
            return this.commentManager.createComment(docModel, comment, author);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModel createComment(DocumentModel docModel, String comment, String author) throws ClientException {
        try {
            return this.commentManager.createComment(docModel, comment, author);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    private String updateAuthor(DocumentModel docModel) {
        String author;
        try {
            author = (String)docModel.getProperty("comment", "author");
        }
        catch (ClientException e) {
            author = null;
        }
        if (author == null) {
            author = this.context.getCallerPrincipal().getName();
            try {
                docModel.setProperty("comment", "author", (Object)author);
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        return author;
    }

    public DocumentModel createComment(DocumentModel docModel, DocumentModel comment) throws ClientException {
        try {
            this.updateAuthor(comment);
            return this.commentManager.createComment(docModel, comment);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void deleteComment(DocumentModel docModel, DocumentModel comment) throws ClientException {
        try {
            this.commentManager.deleteComment(docModel, comment);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<DocumentModel> getComments(DocumentModel docModel) throws ClientException {
        try {
            return this.commentManager.getComments(docModel);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModel createComment(DocumentModel docModel, DocumentModel parent, DocumentModel child) throws ClientException {
        try {
            this.updateAuthor(child);
            return this.commentManager.createComment(docModel, parent, child);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<DocumentModel> getComments(DocumentModel docModel, DocumentModel parent) throws ClientException {
        try {
            return this.commentManager.getComments(docModel, parent);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<DocumentModel> getDocumentsForComment(DocumentModel comment) throws ClientException {
        try {
            return this.commentManager.getDocumentsForComment(comment);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModel createLocatedComment(DocumentModel docModel, DocumentModel comment, String path) throws ClientException {
        try {
            return this.commentManager.createLocatedComment(docModel, comment, path);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }
}

