/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.versioning.ejb;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.Stateless;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.platform.versioning.api.SnapshotOptions;
import org.nuxeo.ecm.platform.versioning.api.VersionIncEditOptions;
import org.nuxeo.ecm.platform.versioning.api.VersioningManager;
import org.nuxeo.ecm.platform.versioning.service.ServiceHelper;
import org.nuxeo.ecm.platform.versioning.service.VersioningService;

@Stateless
@Local(value={VersioningManager.class})
@Remote(value={VersioningManager.class})
public class VersioningManagerBean
implements VersioningManager {
    private static final Log log = LogFactory.getLog(VersioningManagerBean.class);
    @Transient
    private VersioningService service;

    @PostConstruct
    public void ejbCreate() {
        log.debug((Object)"PostConstruct");
        this.initService();
    }

    @PostActivate
    public void ejbActivate() {
        log.debug((Object)"PostActivate");
        this.initService();
    }

    @PrePassivate
    public void ejbPassivate() {
        log.debug((Object)"PrePassivate");
    }

    @Remove
    public void ejbRemove() {
        log.debug((Object)"Remove");
    }

    private void initService() {
        if (this.service == null) {
            this.service = ServiceHelper.getVersioningService();
        }
    }

    protected Map<String, Object> getDocumentManagerProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("participant", new UserPrincipal("Administrator"));
        return props;
    }

    public VersionIncEditOptions getVersionIncEditOptions(DocumentModel document) throws ClientException {
        return this.service.getVersionIncEditOptions(document);
    }

    public DocumentModel incrementMajor(DocumentModel document) throws ClientException {
        return this.service.incrementMajor(document);
    }

    public DocumentModel incrementMinor(DocumentModel document) throws ClientException {
        return this.service.incrementMinor(document);
    }

    public String getMajorVersionPropertyName(String documentType) {
        return this.service.getMajorVersionPropertyName(documentType);
    }

    public String getMinorVersionPropertyName(String documentType) {
        return this.service.getMinorVersionPropertyName(documentType);
    }

    public String getVersionLabel(DocumentModel document) throws ClientException {
        return this.service.getVersionLabel(document);
    }

    public SnapshotOptions getCreateSnapshotOption(DocumentModel document) throws ClientException {
        return this.service.getCreateSnapshotOption(document);
    }
}

