/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.versioning.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.versioning.api.SnapshotOptions;

@XObject(value="createSnapshot")
public class CreateSnapshotDescriptor {
    private static final Log log = LogFactory.getLog(CreateSnapshotDescriptor.class);
    @XNode(value="@name")
    private String name;
    @XNode(value="@optional")
    private boolean optional;
    @XNode(value="@default")
    private boolean defaultCreate;
    @XNodeList(value="lifecycleState", type=String[].class, componentType=String.class)
    private String[] lifecycleStates;

    public CreateSnapshotDescriptor() {
        log.debug((Object)"<CreateSnapshotDescriptor:init>");
    }

    public String getName() {
        return this.name;
    }

    public boolean getOptional() {
        return this.optional;
    }

    public boolean getDefaultCreate() {
        return this.defaultCreate;
    }

    public String[] getLifecycleStates() {
        return this.lifecycleStates;
    }

    public boolean applyForLifecycleState(String lifecycleState) {
        if (lifecycleState == null) {
            throw new IllegalArgumentException("null lifecycleState");
        }
        for (String lcState : this.lifecycleStates) {
            if (!lcState.equals("*") && !lcState.equals(lifecycleState)) continue;
            return true;
        }
        return false;
    }

    public SnapshotOptions getSnapshotOption() {
        if (this.optional) {
            if (this.defaultCreate) {
                return SnapshotOptions.DISPLAY_SELECTED;
            }
            return SnapshotOptions.DISPLAY_NOT_SELECTED;
        }
        return SnapshotOptions.NOT_DISPLAYED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" {name=").append(this.name).append('}');
        return sb.toString();
    }
}

