/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.versioning.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.versioning.service.RuleDescriptor;
import org.nuxeo.ecm.platform.versioning.service.RuleOptionDescriptor;

@XObject(value="versioningRuleEdit")
public class EditBasedRuleDescriptor
implements RuleDescriptor {
    private static final Log log = LogFactory.getLog(EditBasedRuleDescriptor.class);
    @XNode(value="@name")
    private String name;
    @XNode(value="@action")
    private String action;
    @XNode(value="@lifecycleState")
    private String lifecycleState;
    @XNodeList(value="option", type=RuleOptionDescriptor[].class, componentType=RuleOptionDescriptor.class)
    private RuleOptionDescriptor[] options;
    @XNodeList(value="includeDocType", type=String[].class, componentType=String.class)
    private String[] includeDocTypes;
    @XNodeList(value="excludeDocType", type=String[].class, componentType=String.class)
    private String[] excludeDocTypes;
    @XNode(value="@enabled")
    private boolean enabled = true;

    public EditBasedRuleDescriptor() {
        log.debug((Object)"<EditBasedRuleDescriptor:init>");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    public String getLifecycleState() {
        return this.lifecycleState;
    }

    public RuleOptionDescriptor[] getOptions() {
        return this.options;
    }

    public String[] getExcludeDocTypes() {
        return this.excludeDocTypes;
    }

    public boolean isDocTypeExcluded(String docType) {
        for (String excludedDocType : this.excludeDocTypes) {
            if (!excludedDocType.equals(docType)) continue;
            return true;
        }
        return false;
    }

    public boolean isDocTypeIncluded(String docType) {
        if (this.includeDocTypes.length == 0) {
            return true;
        }
        for (String includedDocType : this.includeDocTypes) {
            if (!includedDocType.equals(docType)) continue;
            return true;
        }
        return false;
    }

    public boolean isDocTypeAccounted(String docType) {
        return !this.isDocTypeExcluded(docType) && this.isDocTypeIncluded(docType);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" {name=").append(this.name).append('}');
        return sb.toString();
    }
}

