/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Folder;
import org.apache.chemistry.NameConstraintViolationException;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.Policy;
import org.apache.chemistry.Property;
import org.apache.chemistry.Relationship;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.Type;
import org.apache.chemistry.UpdateConflictException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CMISObject
extends ObjectId {
    public Connection getConnection();

    public void move(Folder var1, Folder var2) throws NameConstraintViolationException, UpdateConflictException;

    public void delete() throws UpdateConflictException;

    public void unfile();

    public Folder getParent();

    public Collection<Folder> getParents();

    public List<Relationship> getRelationships(RelationshipDirection var1, String var2, boolean var3);

    public void applyPolicy(Policy var1);

    public void removePolicy(Policy var1);

    public Collection<Policy> getPolicies();

    public Type getType();

    public BaseType getBaseType();

    public Property getProperty(String var1);

    public Map<String, Property> getProperties();

    public Serializable getValue(String var1);

    public void setValue(String var1, Serializable var2) throws NameConstraintViolationException, UpdateConflictException;

    public void setValues(Map<String, Serializable> var1) throws NameConstraintViolationException, UpdateConflictException;

    public ContentStream getContentStream(String var1) throws IOException;

    public void save() throws NameConstraintViolationException, UpdateConflictException;

    public String getString(String var1);

    public String[] getStrings(String var1);

    public BigDecimal getDecimal(String var1);

    public BigDecimal[] getDecimals(String var1);

    public Integer getInteger(String var1);

    public Integer[] getIntegers(String var1);

    public Boolean getBoolean(String var1);

    public Boolean[] getBooleans(String var1);

    public Calendar getDateTime(String var1);

    public Calendar[] getDateTimes(String var1);

    public URI getURI(String var1);

    public URI[] getURIs(String var1);

    public String getId(String var1);

    public String[] getIds(String var1);

    public String getXML(String var1);

    public String[] getXMLs(String var1);

    public String getHTML(String var1);

    public String[] getHTMLs(String var1);

    @Override
    public String getId();

    public String getTypeId();

    public String getCreatedBy();

    public Calendar getCreationDate();

    public String getLastModifiedBy();

    public Calendar getLastModificationDate();

    public String getChangeToken();

    public String getName();

    public boolean isImmutable();

    public boolean isLatestVersion();

    public boolean isMajorVersion();

    public boolean isLatestMajorVersion();

    public String getVersionLabel();

    public String getVersionSeriesId();

    public boolean isVersionSeriesCheckedOut();

    public String getVersionSeriesCheckedOutBy();

    public String getVersionSeriesCheckedOutId();

    public String getCheckInComment();

    public void setName(String var1) throws NameConstraintViolationException;
}

