/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.ecm.platform.content.template.listener.RepositoryInitializationListener;
import org.nuxeo.ecm.platform.content.template.service.ContentFactory;
import org.nuxeo.ecm.platform.content.template.service.ContentFactoryDescriptor;
import org.nuxeo.ecm.platform.content.template.service.ContentTemplateService;
import org.nuxeo.ecm.platform.content.template.service.FactoryBindingDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ContentTemplateServiceImpl
extends DefaultComponent
implements ContentTemplateService {
    public static final String NAME = "org.nuxeo.ecm.platform.content.template.service.TemplateService";
    public static final String FACTORY_DECLARATION_EP = "factory";
    public static final String FACTORY_BINDING_EP = "factoryBinding";
    private static final Log log = LogFactory.getLog(ContentTemplateServiceImpl.class);
    private Map<String, ContentFactoryDescriptor> factories;
    private Map<String, FactoryBindingDescriptor> factoryBindings;
    private Map<String, ContentFactory> factoryInstancesByType;
    private Map<String, ContentFactory> factoryInstancesByFacet;
    private RepositoryInitializationHandler initializationHandler;

    public void activate(ComponentContext context) {
        this.factories = new HashMap<String, ContentFactoryDescriptor>();
        this.factoryBindings = new HashMap<String, FactoryBindingDescriptor>();
        this.factoryInstancesByType = new HashMap<String, ContentFactory>();
        this.factoryInstancesByFacet = new HashMap<String, ContentFactory>();
        this.initializationHandler = new RepositoryInitializationListener();
        this.initializationHandler.install();
    }

    public void deactivate(ComponentContext context) throws Exception {
        if (this.initializationHandler != null) {
            this.initializationHandler.uninstall();
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        block12: {
            if (extensionPoint.equals(FACTORY_DECLARATION_EP)) {
                ContentFactoryDescriptor descriptor = (ContentFactoryDescriptor)contribution;
                this.factories.put(descriptor.getName(), descriptor);
            } else if (extensionPoint.equals(FACTORY_BINDING_EP)) {
                FactoryBindingDescriptor descriptor = (FactoryBindingDescriptor)contribution;
                if (this.factories.containsKey(descriptor.getFactoryName())) {
                    String targetType = descriptor.getTargetType();
                    String targetFacet = descriptor.getTargetFacet();
                    if (null != targetType) {
                        this.factoryBindings.put(targetType, descriptor);
                    } else {
                        this.factoryBindings.put(targetFacet, descriptor);
                    }
                    ContentFactoryDescriptor factoryDescriptor = this.factories.get(descriptor.getFactoryName());
                    try {
                        ContentFactory factory = factoryDescriptor.getClassName().newInstance();
                        Boolean factoryOK = factory.initFactory(descriptor.getOptions(), descriptor.getRootAcl(), descriptor.getTemplate());
                        if (!factoryOK.booleanValue()) {
                            log.error((Object)("Error while initializing instance of factory " + factoryDescriptor.getName()));
                            return;
                        }
                        if (null != targetType) {
                            this.factoryInstancesByType.put(targetType, factory);
                            break block12;
                        }
                        this.factoryInstancesByFacet.put(targetFacet, factory);
                    }
                    catch (InstantiationException e) {
                        log.error((Object)("Error while creating instance of factory " + factoryDescriptor.getName() + " :" + e.getMessage()));
                    }
                    catch (IllegalAccessException e) {
                        log.error((Object)("Error while creating instance of factory " + factoryDescriptor.getName() + " :" + e.getMessage()));
                    }
                } else {
                    log.error((Object)("Factory Binding" + descriptor.getName() + " can not be registred since Factory " + descriptor.getFactoryName() + " is not registred"));
                }
            }
        }
    }

    @Override
    public ContentFactory getFactoryForType(String documentType) {
        return this.factoryInstancesByType.get(documentType);
    }

    public ContentFactory getFactoryForFacet(String facet) {
        return this.factoryInstancesByFacet.get(facet);
    }

    @Override
    public void executeFactoryForType(DocumentModel createdDocument) throws ClientException {
        ContentFactory factory = this.getFactoryForType(createdDocument.getType());
        if (factory != null) {
            factory.createContentStructure(createdDocument);
        }
        Set facets = createdDocument.getDeclaredFacets();
        for (String facet : facets) {
            factory = this.getFactoryForFacet(facet);
            if (factory == null) continue;
            factory.createContentStructure(createdDocument);
        }
    }

    public Map<String, ContentFactoryDescriptor> getFactories() {
        return this.factories;
    }

    public Map<String, FactoryBindingDescriptor> getFactoryBindings() {
        return this.factoryBindings;
    }

    public Map<String, ContentFactory> getFactoryInstancesByType() {
        return this.factoryInstancesByType;
    }

    public Map<String, ContentFactory> getFactoryInstancesByFacet() {
        return this.factoryInstancesByFacet;
    }
}

