/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.scheduler.core.service;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.scheduler.core.EventJob;
import org.nuxeo.ecm.platform.scheduler.core.interfaces.Schedule;
import org.nuxeo.ecm.platform.scheduler.core.interfaces.SchedulerRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerRegistryService
extends DefaultComponent
implements SchedulerRegistry {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.scheduler.core.service.SchedulerService");
    private static final Log log = LogFactory.getLog(SchedulerRegistryService.class);
    private RuntimeContext bundle;
    private Scheduler scheduler;

    public void activate(ComponentContext context) throws Exception {
        log.debug((Object)"Activate");
        this.bundle = context.getRuntimeContext();
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        this.scheduler = schedulerFactory.getScheduler();
        this.scheduler.start();
    }

    public void deactivate(ComponentContext context) throws Exception {
        log.debug((Object)"Deactivate");
        this.scheduler.shutdown();
    }

    public void registerExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            Schedule schedule = (Schedule)contrib;
            this.registerSchedule(schedule);
        }
    }

    public void unregisterExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            Schedule schedule = (Schedule)contrib;
            this.unregisterSchedule(schedule);
        }
    }

    public RuntimeContext getContext() {
        return this.bundle;
    }

    @Override
    public void registerSchedule(Schedule schedule) {
        this.registerSchedule(schedule, null);
    }

    @Override
    public void registerSchedule(Schedule schedule, Map<String, Serializable> parameters) {
        CronTrigger trigger;
        log.info((Object)("Registering " + schedule));
        JobDetail job = new JobDetail(schedule.getId(), "nuxeo", EventJob.class);
        JobDataMap map = job.getJobDataMap();
        map.put("eventId", schedule.getEventId());
        map.put("eventCategory", schedule.getEventCategory());
        map.put("username", schedule.getUsername());
        map.put("password", schedule.getPassword());
        if (parameters != null) {
            map.putAll(parameters);
        }
        try {
            trigger = new CronTrigger(schedule.getId(), "nuxeo", schedule.getCronExpression());
        }
        catch (ParseException e) {
            log.error((Object)String.format("invalid cron expresion '%s' for schedule '%s'", schedule.getCronExpression(), schedule.getId()), (Throwable)e);
            return;
        }
        try {
            this.scheduler.scheduleJob(job, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            log.error((Object)String.format("failed to schedule job with id '%s': %s", schedule.getId(), e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public Boolean unregisterSchedule(String scheduleId) {
        log.info((Object)("Unregistering schedule with id" + scheduleId));
        try {
            return this.scheduler.deleteJob(scheduleId, "nuxeo");
        }
        catch (SchedulerException e) {
            log.error((Object)String.format("failed to unschedule job with '%s': %s", scheduleId, e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean unregisterSchedule(Schedule schedule) {
        return this.unregisterSchedule(schedule.getId());
    }
}

