/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.faceted.search.jsf.service;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.faceted.search.api.service.FacetedSearchService;
import org.nuxeo.ecm.platform.faceted.search.jsf.service.Configuration;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class FacetedSearchServiceImpl
extends DefaultComponent
implements FacetedSearchService {
    public static final String FACETED_SEARCH_FLAG = "FACETED_SEARCH";
    public static final String CONFIGURATION_EP = "configuration";
    protected Configuration configuration;
    protected ContentViewService contentViewService;
    protected UserWorkspaceService userWorkspaceService;

    public Set<String> getContentViewNames() throws ClientException {
        ContentViewService contentViewService = this.getContentViewService();
        return contentViewService.getContentViewNames(FACETED_SEARCH_FLAG);
    }

    protected ContentViewService getContentViewService() throws ClientException {
        if (this.contentViewService == null) {
            try {
                this.contentViewService = (ContentViewService)Framework.getService(ContentViewService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to ContentViewService. " + e.getMessage();
                throw new ClientException(errMsg, (Throwable)e);
            }
            if (this.contentViewService == null) {
                throw new ClientException("ContentViewService service not bound");
            }
        }
        return this.contentViewService;
    }

    protected UserWorkspaceService getUserWorkspaceService() throws ClientException {
        if (this.userWorkspaceService == null) {
            try {
                this.userWorkspaceService = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to UserWorkspaceService. " + e.getMessage();
                throw new ClientException(errMsg, (Throwable)e);
            }
            if (this.userWorkspaceService == null) {
                throw new ClientException("UserWorkspaceService service not bound");
            }
        }
        return this.userWorkspaceService;
    }

    public DocumentModel saveSearch(CoreSession session, ContentView facetedSearchContentView, String title) throws ClientException {
        DocumentModel uws = this.getCurrentUserPersonalWorkspace(session);
        String rootSavedSearchesTitle = this.configuration.getRootSavedSearchesTitle();
        String rootSavedSearchesName = IdUtils.generatePathSegment((String)rootSavedSearchesTitle);
        Path rootSavedSearchesPath = new Path(uws.getPathAsString()).append(rootSavedSearchesName);
        if (!session.exists((DocumentRef)new PathRef(rootSavedSearchesPath.toString()))) {
            DocumentModel rootSavedSearches = session.createDocumentModel(uws.getPathAsString(), rootSavedSearchesName, "Folder");
            rootSavedSearches.setPropertyValue("dc:title", (Serializable)((Object)rootSavedSearchesTitle));
            session.createDocument(rootSavedSearches);
            session.save();
        }
        DocumentModel searchDoc = facetedSearchContentView.getSearchDocumentModel();
        searchDoc.setPropertyValue("fs:content_view_name", (Serializable)((Object)facetedSearchContentView.getName()));
        searchDoc.setPropertyValue("dc:title", (Serializable)((Object)title));
        searchDoc.setPathInfo(rootSavedSearchesPath.toString(), IdUtils.generatePathSegment((String)title));
        searchDoc = session.createDocument(searchDoc);
        session.save();
        return searchDoc;
    }

    public List<DocumentModel> getCurrentUserSavedSearches(CoreSession session) throws ClientException {
        return this.getDocuments("USER_SAVED_SEARCHES", session.getPrincipal().getName());
    }

    protected DocumentModel getCurrentUserPersonalWorkspace(CoreSession session) throws ClientException {
        UserWorkspaceService userWorkspaceService = this.getUserWorkspaceService();
        return userWorkspaceService.getCurrentUserPersonalWorkspace(session, null);
    }

    protected List<DocumentModel> getDocuments(String contentViewName, Object ... parameters) throws ClientException {
        ContentViewService contentViewService = this.getContentViewService();
        ContentView contentView = contentViewService.getContentView(contentViewName);
        contentView.resetPageProvider();
        return contentView.getPageProviderWithParams(parameters).getCurrentPage();
    }

    public List<DocumentModel> getOtherUsersSavedSearches(CoreSession session) throws ClientException {
        return this.getDocuments("ALL_SAVED_SEARCHES", session.getPrincipal().getName());
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONFIGURATION_EP.equals(extensionPoint)) {
            Configuration desc = (Configuration)contribution;
            if (this.configuration != null) {
                desc = this.mergeConfigurationDescriptor(this.configuration, desc);
            }
            this.configuration = desc;
        }
    }

    protected Configuration mergeConfigurationDescriptor(Configuration oldDesc, Configuration newDesc) {
        if (newDesc.getRootSavedSearchesTitle() != null) {
            oldDesc.rootSavedSearchesTitle = newDesc.getRootSavedSearchesTitle();
        }
        return oldDesc;
    }
}

