/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmisRepositoryContextListener
implements ServletContextListener {
    public static final String SERVICES_FACTORY = "org.apache.chemistry.opencmis.servicesfactory";
    private static final Log log = LogFactory.getLog((String)CmisRepositoryContextListener.class.getName());
    private static final String CONFIG_INIT_PARAM = "org.apache.chemistry.opencmis.REPOSITORY_CONFIG_FILE";
    private static final String CONFIG_FILENAME = "/repository.properties";
    private static final String PROPERTY_CLASS = "class";

    public void contextInitialized(ServletContextEvent sce) {
        String configFilename = sce.getServletContext().getInitParameter(CONFIG_INIT_PARAM);
        if (configFilename == null) {
            configFilename = CONFIG_FILENAME;
        }
        CmisServiceFactory factory = this.createServiceFactory(configFilename);
        sce.getServletContext().setAttribute(SERVICES_FACTORY, (Object)factory);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        CmisServiceFactory factory = (CmisServiceFactory)sce.getServletContext().getAttribute(SERVICES_FACTORY);
        if (factory != null) {
            factory.destroy();
        }
    }

    private CmisServiceFactory createServiceFactory(String filename) {
        InputStream stream = this.getClass().getResourceAsStream(filename);
        if (stream == null) {
            log.warn((Object)"Cannot find configuration!");
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException e) {
            log.warn((Object)("Cannot load configuration: " + e), (Throwable)e);
            return null;
        }
        String className = props.getProperty(PROPERTY_CLASS);
        if (className == null) {
            log.warn((Object)"Configuration doesn't contain the property 'class'!");
            return null;
        }
        Object object = null;
        try {
            object = Class.forName(className).newInstance();
        }
        catch (Exception e) {
            log.warn((Object)("Could not create a services factory instance: " + e), (Throwable)e);
            return null;
        }
        if (!(object instanceof CmisServiceFactory)) {
            log.warn((Object)"The provided class is not an instance of CmisServiceFactory!");
        }
        CmisServiceFactory factory = object;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            parameters.put(key, value);
        }
        factory.init(parameters);
        log.info((Object)("Initialized Services Factory: " + parameters));
        return factory;
    }
}

