/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.admin.management;

import java.io.File;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.admin.management.FileContainerResource;
import org.nuxeo.ecm.webengine.model.view.TemplateView;
import org.nuxeo.runtime.api.Framework;

public class RootContainerResource
extends FileContainerResource {
    public RootContainerResource(File root) {
        super(root);
    }

    @GET
    @Produces(value={"application/atom+xml"})
    public Object listFiles() {
        File[] files = this.root.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        return new TemplateView((Object)this, "root-resources.ftl").arg("root", (Object)this.root.getName()).arg("resources", (Object)files);
    }

    @Path(value="@schemas")
    public FileContainerResource getSchemas() {
        Environment env = Environment.getDefault();
        return new FileContainerResource(new File(env.getHome(), "schemas"), true);
    }

    @Path(value="@components")
    public FileContainerResource getComponents() {
        Environment env = Environment.getDefault();
        return new FileContainerResource(new File(env.getData(), "components"), true);
    }

    @GET
    @Path(value="@reload")
    public void reload() {
        try {
            System.out.println("Reloading resources ...");
            Framework.reloadResourceLoader();
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }
}

